<?php
session_start();
require_once __DIR__ . '/../../config/database.php';

class AdminAuth {
    private $conn;
    
    public function __construct() {
        $this->conn = getDB();
    }
    
    public function login($email, $password) {
        // For demo purposes, using hardcoded admin credentials
        // In production, you should store admin credentials in database
        $admin_credentials = [
            'admin@perfume.com' => 'admin123',
            'owner@perfume.com' => 'owner123'
        ];
        
        if (isset($admin_credentials[$email]) && $admin_credentials[$email] === $password) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_email'] = $email;
            $_SESSION['admin_name'] = $email === 'admin@perfume.com' ? 'Admin' : 'Store Owner';
            return true;
        }
        
        return false;
    }
    
    public function logout() {
        session_destroy();
        return true;
    }
    
    public function isLoggedIn() {
        return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
    }
    
    public function requireLogin() {
        if (!$this->isLoggedIn()) {
            header('Location: login.php');
            exit();
        }
    }
    
    public function getAdminName() {
        return $_SESSION['admin_name'] ?? 'Admin';
    }
    
    public function getAdminEmail() {
        return $_SESSION['admin_email'] ?? '';
    }
}

$adminAuth = new AdminAuth();
?>