<?php
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

$adminAuth->requireLogin();

$orderId = $_GET['id'] ?? null;

if (!$orderId) {
    die('Order ID is required');
}

// Get order details
$order = $adminFunctions->getOrderById($orderId);

if (!$order) {
    die('Order not found');
}

// Get order items
$orderItems = $adminFunctions->getOrderItems($orderId);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice - Order #<?php echo $order['order_number']; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background: #f5f5f5;
        }
        
        .invoice-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .invoice-header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #000;
            padding-bottom: 20px;
        }
        
        .invoice-header h1 {
            margin: 0;
            color: #000;
            font-size: 28px;
        }
        
        .invoice-header p {
            margin: 5px 0 0 0;
            color: #666;
        }
        
        .invoice-details {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-bottom: 30px;
        }
        
        .detail-section h3 {
            margin: 0 0 10px 0;
            color: #000;
            font-size: 16px;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
        }
        
        .detail-section p {
            margin: 5px 0;
            color: #333;
        }
        
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .items-table th,
        .items-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }
        
        .items-table th {
            background: #f8f9fa;
            font-weight: 600;
            color: #000;
        }
        
        .items-table .text-right {
            text-align: right;
        }
        
        .total-section {
            margin-top: 20px;
            text-align: right;
        }
        
        .total-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        
        .total-row.final {
            font-weight: bold;
            font-size: 18px;
            color: #000;
            border-top: 2px solid #000;
            margin-top: 10px;
            padding-top: 15px;
        }
        
        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .status-delivered {
            background: #4caf50;
            color: white;
        }
        
        @media print {
            body {
                background: white;
                padding: 0;
            }
            
            .invoice-container {
                box-shadow: none;
                border-radius: 0;
            }
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <div class="invoice-header">
            <h1>2 DAYS PARFUME</h1>
            <p>Invoice for Order #<?php echo $order['order_number']; ?></p>
        </div>
        
        <div class="invoice-details">
            <div class="detail-section">
                <h3>Order Information</h3>
                <p><strong>Order Number:</strong> <?php echo $order['order_number']; ?></p>
                <p><strong>Order Date:</strong> <?php echo date('M j, Y g:i A', strtotime($order['created_at'])); ?></p>
                <p><strong>Status:</strong> <span class="status-badge status-delivered">Delivered</span></p>
                <p><strong>Payment Method:</strong> <?php echo htmlspecialchars($order['payment_method']); ?></p>
            </div>
            
            <div class="detail-section">
                <h3>Customer Information</h3>
                <?php 
                $shipping_address = json_decode($order['shipping_address'], true);
                if ($shipping_address):
                ?>
                <p><strong>Name:</strong> <?php echo htmlspecialchars($shipping_address['first_name'] . ' ' . $shipping_address['last_name']); ?></p>
                <p><strong>Email:</strong> <?php echo htmlspecialchars($shipping_address['email']); ?></p>
                <p><strong>Phone:</strong> <?php echo htmlspecialchars($shipping_address['phone']); ?></p>
                <p><strong>Address:</strong> <?php echo htmlspecialchars($shipping_address['address']); ?></p>
                <p><strong>City:</strong> <?php echo htmlspecialchars($shipping_address['city']); ?>, <?php echo htmlspecialchars($shipping_address['state']); ?></p>
                <p><strong>Postal Code:</strong> <?php echo htmlspecialchars($shipping_address['zip_code']); ?></p>
                <?php endif; ?>
            </div>
        </div>
        
        <table class="items-table">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Size</th>
                    <th class="text-right">Quantity</th>
                    <th class="text-right">Price</th>
                    <th class="text-right">Total</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($orderItems as $item): ?>
                <tr>
                    <td><?php echo htmlspecialchars($item['product_name']); ?></td>
                    <td><?php echo htmlspecialchars($item['size'] ?? 'N/A'); ?></td>
                    <td class="text-right"><?php echo $item['quantity']; ?></td>
                    <td class="text-right">RM <?php echo number_format($item['price'], 2); ?></td>
                    <td class="text-right">RM <?php echo number_format($item['subtotal'], 2); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <div class="total-section">
            <div class="total-row">
                <span>Subtotal:</span>
                <span>RM <?php echo number_format($order['subtotal'], 2); ?></span>
            </div>
            <div class="total-row">
                <span>Shipping:</span>
                <span>RM <?php echo number_format($order['shipping'], 2); ?></span>
            </div>
            <div class="total-row final">
                <span>Total:</span>
                <span>RM <?php echo number_format($order['total'], 2); ?></span>
            </div>
        </div>
        
        <div style="margin-top: 30px; text-align: center; color: #666; font-size: 12px;">
            <p>Thank you for your business!</p>
            <p>This order was delivered on <?php echo date('M j, Y', strtotime($order['updated_at'])); ?></p>
        </div>
    </div>
    
    <script>
        // Auto-print when page loads
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>