<?php
require_once '../includes/auth.php';

$adminAuth->requireLogin();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Field Presets - Admin Panel</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="sidebar">
        <div class="sidebar-header">
            <img src="../../images/LOGO.png" alt="Logo" class="sidebar-logo">
            <h3>Admin Panel</h3>
        </div>
        <nav class="sidebar-nav">
            <a href="../index.php" class="nav-item">
                <i class="fas fa-th-large"></i>
                <span>Overview</span>
            </a>
            <a href="products.php" class="nav-item">
                <i class="fas fa-box"></i>
                <span>Products</span>
            </a>
            <a href="orders.php" class="nav-item">
                <i class="fas fa-shopping-cart"></i>
                <span>Orders</span>
            </a>
            <a href="delivered.php" class="nav-item">
                <i class="fas fa-check-circle"></i>
                <span>Delivered</span>
            </a>
            <a href="customers.php" class="nav-item">
                <i class="fas fa-users"></i>
                <span>Customers</span>
            </a>
            <a href="feedback.php" class="nav-item">
                <i class="fas fa-comments"></i>
                <span>Feedback</span>
            </a>
            <a href="shipping.php" class="nav-item">
                <i class="fas fa-shipping-fast"></i>
                <span>Shipping</span>
            </a>
            <a href="banners.php" class="nav-item">
                <i class="fas fa-image"></i>
                <span>Banners</span>
            </a>
            <a href="presets.php" class="nav-item active">
                <i class="fas fa-cogs"></i>
                <span>Field Presets</span>
            </a>
            <a href="vouchers.php" class="nav-item">
                <i class="fas fa-ticket-alt"></i>
                <span>Voucher Management</span>
            </a>
            <a href="notifications.php" class="nav-item">
                <i class="fas fa-bell"></i>
                <span>Push Notifications</span>
            </a>
            <a href="analytics.php" class="nav-item">
                <i class="fas fa-chart-bar"></i>
                <span>Analytics</span>
            </a>
            <a href="settings.php" class="nav-item">
                <i class="fas fa-cog"></i>
                <span>Settings</span>
            </a>
        </nav>
        <div class="sidebar-footer">
            <div class="user-info">
                <i class="fas fa-user-circle"></i>
                <span><?php echo htmlspecialchars($adminAuth->getAdminName()); ?></span>
            </div>
            <a href="../logout.php" class="logout-btn">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </div>
    </div>

    <div class="main-content">
        <header class="header">
            <div class="header-left">
                <button class="sidebar-toggle">
                    <i class="fas fa-bars"></i>
                </button>
                <h1>Field Presets</h1>
            </div>
            <div class="header-right">
                <div class="header-actions">
                    <a href="products.php" class="btn btn-outline">
                        <i class="fas fa-box"></i>
                        Products
                    </a>
                </div>
            </div>
        </header>

        <div class="page-content">
            <div class="alert" id="presetInfo" style="display:none"></div>

            <div class="card">
                <div class="card-header" style="display:flex;justify-content:space-between;align-items:center;gap:12px;flex-wrap:wrap;">
                    <h3 style="margin:0">Add Preset</h3>
                    <div style="display:flex;gap:10px;align-items:center;">
                        <select id="field_type" class="filter-select">
                            <option value="brand">Brand</option>
                            <option value="size">Size</option>
                            <option value="season">Season</option>
                            <option value="notes">Notes</option>
                            <option value="scent">Scent</option>
                            <option value="recommendation">Recommendation</option>
                        </select>
                        <input id="preset_value" type="text" class="search-input" placeholder="Preset value e.g. 10ml">
                        <button id="addPresetBtn" class="btn btn-primary"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
                <div class="card-content">
                    <div id="presetsWrap" style="display:grid;grid-template-columns:repeat(auto-fit,minmax(220px,1fr));gap:16px;"></div>
                </div>
            </div>
        </div>
    </div>

    <script src="../assets/js/preset-manager.js"></script>
    <script>
    (function(){
        const wrap = document.getElementById('presetsWrap');
        const info = document.getElementById('presetInfo');
        const addBtn = document.getElementById('addPresetBtn');
        const typeEl = document.getElementById('field_type');
        const valueEl = document.getElementById('preset_value');

        function render() {
            wrap.innerHTML = '';
            const data = window.presetManager.presets || {};
            const types = window.presetManager.getFieldTypes();
            // Hide volume and category sections
            const hiddenFields = ['volume', 'category'];
            Object.keys(types).forEach(function(key){
                // Skip volume and category
                if (hiddenFields.includes(key)) return;
                
                const list = data[key] || [];
                const card = document.createElement('div');
                card.className = 'card';
                card.innerHTML = '<div class="card-header"><h3 style="margin:0">'+types[key]+'</h3></div>';
                const body = document.createElement('div');
                body.className = 'card-content';
                if (!list.length) {
                    body.innerHTML = '<p style="color:#666">No presets yet.</p>';
                } else {
                    const table = document.createElement('table');
                    table.className = 'data-table';
                    table.style.width = '100%';
                    const thead = document.createElement('thead');
                    thead.innerHTML = '<tr><th style="width:80px">Action</th><th>Value</th></tr>';
                    table.appendChild(thead);
                    const tbody = document.createElement('tbody');
                    list.forEach(function(item){
                        const tr = document.createElement('tr');
                        const tdAction = document.createElement('td');
                        tdAction.style.width = '80px';
                        tdAction.innerHTML = '<button data-id="'+item.id+'" class="btn btn-outline btn-sm" title="Delete" style="padding:6px 10px"><i class="fas fa-trash"></i></button>';
                        const tdValue = document.createElement('td');
                        tdValue.setAttribute('data-editable', '1');
                        tdValue.setAttribute('data-id', item.id);
                        tdValue.setAttribute('data-field-type', key);
                        tdValue.innerHTML = '<span class="preset-text">'+item.preset_value+'</span>';
                        tr.appendChild(tdAction);
                        tr.appendChild(tdValue);
                        tbody.appendChild(tr);
                    });
                    table.appendChild(tbody);
                    body.appendChild(table);
                    body.addEventListener('click', function(e){
                        if (e.target.closest('button')) {
                            const id = e.target.closest('button').getAttribute('data-id');
                            window.presetManager.deletePreset(id).then(function(res){
                                show(res.success ? 'Deleted' : res.error, res.success);
                                render();
                            });
                        }
                        const cell = e.target.closest('td[data-editable="1"]');
                        if (cell && !cell.querySelector('input')) {
                            const currentTextEl = cell.querySelector('.preset-text');
                            const current = currentTextEl ? currentTextEl.textContent : '';
                            const input = document.createElement('input');
                            input.type = 'text';
                            input.value = current;
                            input.style.width = '100%';
                            input.style.boxSizing = 'border-box';
                            input.style.padding = '8px 10px';
                            cell.innerHTML = '';
                            cell.appendChild(input);
                            input.focus();
                            const commit = function(save){
                                const newVal = input.value.trim();
                                if (!save || newVal === current || newVal === '') {
                                    cell.innerHTML = '<span class="preset-text">'+current+'</span>';
                                    return;
                                }
                                const id = cell.getAttribute('data-id');
                                const fieldType = cell.getAttribute('data-field-type');
                                window.presetManager.updatePreset({ id: id, field_type: fieldType, field_name: fieldType, preset_value: newVal }).then(function(res){
                                    show(res.success ? 'Updated' : res.error, res.success);
                                    render();
                                });
                            };
                            input.addEventListener('keydown', function(ev){
                                if (ev.key === 'Enter') { commit(true); }
                                if (ev.key === 'Escape') { commit(false); }
                            });
                            input.addEventListener('blur', function(){ commit(true); });
                        }
                    });
                }
                card.appendChild(body);
                wrap.appendChild(card);
            });
        }

        function show(message, ok){
            info.style.display = 'block';
            info.textContent = message;
            info.style.backgroundColor = ok ? '#d4edda' : '#f8d7da';
            info.style.color = ok ? '#155724' : '#721c24';
            setTimeout(function(){ info.style.display = 'none'; }, 2000);
        }

        addBtn.addEventListener('click', function(){
            const type = typeEl.value.trim();
            const value = valueEl.value.trim();
            if (!value) {
                show('Please enter a preset value', false);
                return;
            }
            window.presetManager.addPreset({field_type: type, field_name: type, preset_value: value}).then(function(res){
                show(res.success ? 'Added' : res.error, res.success);
                if (res.success) { valueEl.value=''; render(); }
            });
        });

        // Initial render after presets load
        setTimeout(render, 300);
        document.addEventListener('presetAdded', render);
        document.addEventListener('presetDeleted', render);
        document.addEventListener('presetUpdated', render);
    })();
    </script>
</body>
</html>

