<?php
require_once '../includes/auth.php';
require_once '../includes/functions.php';

$adminAuth->requireLogin();

$success = '';
$error = '';

// Handle settings update
if ($_POST) {
    // This is a placeholder for settings functionality
    // In a real application, you would save settings to database
    $success = 'Settings updated successfully!';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - Admin Panel</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <img src="../../images/LOGO.png" alt="Logo" class="sidebar-logo">
            <h3>Admin Panel</h3>
        </div>
        
        <nav class="sidebar-nav">
            <a href="../index.php" class="nav-item">
                <i class="fas fa-th-large"></i>
                <span>Overview</span>
            </a>
            <a href="products.php" class="nav-item">
                <i class="fas fa-box"></i>
                <span>Products</span>
            </a>
            <a href="orders.php" class="nav-item">
                <i class="fas fa-shopping-cart"></i>
                <span>Orders</span>
            </a>
            <a href="delivered.php" class="nav-item">
                <i class="fas fa-check-circle"></i>
                <span>Delivered</span>
            </a>
            <a href="customers.php" class="nav-item">
                <i class="fas fa-users"></i>
                <span>Customers</span>
            </a>
            <a href="feedback.php" class="nav-item">
                <i class="fas fa-comments"></i>
                <span>Feedback</span>
            </a>
            <a href="shipping.php" class="nav-item">
                <i class="fas fa-shipping-fast"></i>
                <span>Shipping</span>
            </a>
            <a href="banners.php" class="nav-item">
                <i class="fas fa-image"></i>
                <span>Banners</span>
            </a>
            <a href="presets.php" class="nav-item">
                <i class="fas fa-cogs"></i>
                <span>Field Presets</span>
            </a>
            <a href="vouchers.php" class="nav-item">
                <i class="fas fa-ticket-alt"></i>
                <span>Voucher Management</span>
            </a>
            <a href="notifications.php" class="nav-item">
                <i class="fas fa-bell"></i>
                <span>Push Notifications</span>
            </a>
            <a href="analytics.php" class="nav-item">
                <i class="fas fa-chart-bar"></i>
                <span>Analytics</span>
            </a>
            <a href="settings.php" class="nav-item active">
                <i class="fas fa-cog"></i>
                <span>Settings</span>
            </a>
        </nav>
        
        <div class="sidebar-footer">
            <div class="user-info">
                <i class="fas fa-user-circle"></i>
                <span><?php echo htmlspecialchars($adminAuth->getAdminName()); ?></span>
            </div>
            <a href="../logout.php" class="logout-btn">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Header -->
        <header class="header">
            <div class="header-left">
                <button class="sidebar-toggle">
                    <i class="fas fa-bars"></i>
                </button>
                <h1>Settings</h1>
            </div>
            <div class="header-right">
                <div class="header-actions">
                    <a href="../index.php" target="_blank" class="btn btn-outline">
                        <i class="fas fa-external-link-alt"></i>
                        View Store
                    </a>
                </div>
            </div>
        </header>

        <!-- Page Content -->
        <div class="page-content">
            <?php if ($success): ?>
                <div class="alert" style="background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;">
                    <i class="fas fa-check-circle"></i>
                    <?php echo htmlspecialchars($success); ?>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i>
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>

            <!-- Store Settings -->
            <div class="form-container">
                <h3>Store Settings</h3>
                <form method="POST">
                    <div class="form-row">
                        <div class="form-group-full">
                            <label for="store_name">Store Name</label>
                            <input type="text" id="store_name" name="store_name" value="2 Days Parfume">
                        </div>
                        <div class="form-group-full">
                            <label for="store_email">Store Email</label>
                            <input type="email" id="store_email" name="store_email" value="info@2daysparfume.com">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group-full">
                            <label for="store_phone">Store Phone</label>
                            <input type="tel" id="store_phone" name="store_phone" value="+60123456789">
                        </div>
                        <div class="form-group-full">
                            <label for="store_address">Store Address</label>
                            <input type="text" id="store_address" name="store_address" value="123 Main Street, Kuala Lumpur">
                        </div>
                    </div>
                    
                    <div class="form-group-full">
                        <label for="store_description">Store Description</label>
                        <textarea id="store_description" name="store_description" rows="3">Premium perfume store offering the finest fragrances for every occasion.</textarea>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">Save Settings</button>
                    </div>
                </form>
            </div>

            <!-- System Information -->
            <div class="form-container">
                <h3>System Information</h3>
                <div class="info-grid">
                    <div class="info-item">
                        <label>PHP Version</label>
                        <span><?php echo PHP_VERSION; ?></span>
                    </div>
                    <div class="info-item">
                        <label>Server Software</label>
                        <span><?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown'; ?></span>
                    </div>
                    <div class="info-item">
                        <label>Database Status</label>
                        <span style="color: #28a745;">
                            <i class="fas fa-check-circle"></i> Connected
                        </span>
                    </div>
                    <div class="info-item">
                        <label>Admin Panel Version</label>
                        <span>1.0.0</span>
                    </div>
                </div>
            </div>

            <!-- Database Management -->
            <div class="form-container">
                <h3>Database Management</h3>
                <div class="db-actions">
                    <button onclick="backupDatabase()" class="btn btn-outline">
                        <i class="fas fa-download"></i>
                        Backup Database
                    </button>
                    <button onclick="optimizeDatabase()" class="btn btn-outline">
                        <i class="fas fa-tools"></i>
                        Optimize Database
                    </button>
                    <button onclick="clearCache()" class="btn btn-outline">
                        <i class="fas fa-broom"></i>
                        Clear Cache
                    </button>
                </div>
            </div>

            <!-- Security Settings -->
            <div class="form-container">
                <h3>Security Settings</h3>
                <form method="POST">
                    <div class="form-row">
                        <div class="form-group-full">
                            <label for="admin_email">Admin Email</label>
                            <input type="email" id="admin_email" name="admin_email" value="<?php echo htmlspecialchars($adminAuth->getAdminEmail()); ?>" readonly>
                        </div>
                        <div class="form-group-full">
                            <label for="session_timeout">Session Timeout (minutes)</label>
                            <input type="number" id="session_timeout" name="session_timeout" value="30" min="5" max="1440">
                        </div>
                    </div>
                    
                    <div class="form-group-full">
                        <label>
                            <input type="checkbox" name="enable_2fa" value="1">
                            Enable Two-Factor Authentication
                        </label>
                    </div>
                    
                    <div class="form-group-full">
                        <label>
                            <input type="checkbox" name="enable_logging" value="1" checked>
                            Enable Activity Logging
                        </label>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">Save Security Settings</button>
                    </div>
                </form>
            </div>

            <!-- Maintenance Mode -->
            <div class="form-container">
                <h3>Maintenance Mode</h3>
                <form method="POST">
                    <div class="form-group-full">
                        <label>
                            <input type="checkbox" name="maintenance_mode" value="1">
                            Enable Maintenance Mode
                        </label>
                        <p style="font-size: 14px; color: #666; margin-top: 5px;">
                            When enabled, only administrators can access the store.
                        </p>
                    </div>
                    
                    <div class="form-group-full">
                        <label for="maintenance_message">Maintenance Message</label>
                        <textarea id="maintenance_message" name="maintenance_message" rows="3">We are currently performing maintenance. Please check back later.</textarea>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" class="btn btn-warning">Update Maintenance Mode</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="../assets/js/admin.js"></script>
    <script>
        function backupDatabase() {
            if (confirm('This will create a backup of your database. Continue?')) {
                // In a real application, this would trigger a database backup
                alert('Database backup initiated. You will be notified when complete.');
            }
        }
        
        function optimizeDatabase() {
            if (confirm('This will optimize your database tables. Continue?')) {
                // In a real application, this would optimize the database
                alert('Database optimization completed.');
            }
        }
        
        function clearCache() {
            if (confirm('This will clear all cached data. Continue?')) {
                // In a real application, this would clear cache
                alert('Cache cleared successfully.');
            }
        }
    </script>
    
    <style>
        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 20px;
        }
        
        .info-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 6px;
            border: 1px solid #ddd;
        }
        
        .info-item label {
            font-weight: 600;
            color: #000;
            margin: 0;
        }
        
        .info-item span {
            color: #666;
        }
        
        .db-actions {
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
        }
        
        @media (max-width: 768px) {
            .info-grid {
                grid-template-columns: 1fr;
            }
            
            .db-actions {
                flex-direction: column;
            }
        }
    </style>
</body>
</html>