# Payment Error Troubleshooting Guide

## Error: "Please try again" at Checkout

This guide will help you diagnose and fix payment errors in the checkout process.

---

## Quick Diagnosis

### Step 1: Run the Test Tool
1. Open your browser and go to: `https://2dayparfum.com/apps/test-toyyibpay.php`
2. This will show you exactly what's wrong with your ToyyibPay integration
3. Follow the recommendations shown on that page

### Step 2: Check Error Logs
Look at your PHP error log for entries containing "toyyibPay". The logs will show:
- What data was sent to ToyyibPay API
- What response was received
- Any errors that occurred

**Common log locations:**
- **cPanel**: `public_html/error_log`
- **Linux/Apache**: `/var/log/apache2/error.log`
- **Windows/XAMPP**: `C:\xampp\apache\logs\error.log`

---

## Common Issues & Solutions

### 1. Insufficient Prepaid Balance (Most Common)

**Error Message:** "Payment system temporarily unavailable"

**Cause:** Your ToyyibPay account doesn't have enough prepaid balance to create bills.

**Solution:**
1. Log in to [ToyyibPay](https://toyyibpay.com)
2. Go to **Prepaid** section
3. Top up your prepaid balance
4. Try the checkout again

**Note:** ToyyibPay charges a small fee from your prepaid balance for each bill created, even if the customer doesn't pay.

---

### 2. Invalid API Credentials

**Error Message:** "Payment configuration error" or "Failed to create payment"

**Cause:** Wrong Secret Key or Category Code in your configuration.

**Solution:**
1. Log in to [ToyyibPay](https://toyyibpay.com)
2. Go to **Settings** → **User Secret Key** and copy your secret key
3. Go to **Category** and copy your category code
4. Update `apps/config/payment.php`:
   ```php
   define('TOYYIBPAY_USER_SECRET_KEY', 'your-secret-key-here');
   define('TOYYIBPAY_CATEGORY_CODE', 'your-category-code-here');
   ```
5. Make sure the category is **active** in your ToyyibPay account

---

### 3. Connection Error

**Error Message:** "Unable to connect to payment gateway"

**Cause:** Server cannot connect to ToyyibPay API.

**Solution:**
1. Check your server's internet connection
2. Verify that your server can make outbound HTTPS requests
3. Check if your firewall is blocking connections to `toyyibpay.com`
4. Contact your hosting provider if the issue persists

---

### 4. Invalid Amount

**Error Message:** "Invalid payment amount"

**Cause:** The order total is zero or negative.

**Solution:**
1. Check that all products have valid prices
2. Verify that the cart total is calculated correctly
3. Check for any voucher/discount issues that might make the total invalid

---

### 5. Category Inactive or Deleted

**Error Message:** "Payment configuration error"

**Cause:** The category code in your config doesn't exist or is inactive.

**Solution:**
1. Log in to [ToyyibPay](https://toyyibpay.com)
2. Go to **Category** section
3. Make sure your category is **active** (green status)
4. If deleted, create a new category and update the code in `apps/config/payment.php`

---

## Testing Your Fix

After making changes:

1. **Run the test tool again:**
   - Go to `https://2dayparfum.com/apps/test-toyyibpay.php`
   - All tests should pass with green checkmarks

2. **Test with a real checkout:**
   - Add a product to cart
   - Go through checkout
   - You should be redirected to ToyyibPay payment page

3. **Check the logs:**
   - Look for "toyyibPay createBill success" in the error log
   - This confirms the bill was created successfully

---

## Understanding ToyyibPay Responses

### Success Response
```
toyyibPay createBill success: abc123xyz
```
This means the bill was created and you'll be redirected to payment page.

### Error Responses

**Insufficient Balance:**
```
toyyibPay createBill failed with error: Insufficient prepaid balance
```
→ Top up your ToyyibPay account

**Invalid Category:**
```
toyyibPay createBill failed with error: Invalid category code
```
→ Check your category code in config/payment.php

**Connection Error:**
```
toyyibPay API cURL Error: Could not resolve host
```
→ Check server internet connection

---

## Configuration Checklist

Make sure these are set correctly in `apps/config/payment.php`:

- [ ] `TOYYIBPAY_USER_SECRET_KEY` - Your secret key from ToyyibPay
- [ ] `TOYYIBPAY_CATEGORY_CODE` - Your active category code
- [ ] `TOYYIBPAY_API_URL` - Should be `https://toyyibpay.com/index.php/api/`
- [ ] `TOYYIBPAY_RETURN_URL` - Should be `https://2dayparfum.com/apps/payment-return.php`
- [ ] `TOYYIBPAY_CALLBACK_URL` - Should be `https://2dayparfum.com/apps/payment-callback.php`
- [ ] `PAYMENT_ENVIRONMENT` - Should be `production`

---

## Still Having Issues?

If you've tried all the above and still getting errors:

1. **Check the detailed error logs** - Look for the exact error message
2. **Contact ToyyibPay Support** - They can check if there are issues with your account
3. **Verify your account status** - Make sure your ToyyibPay account is fully verified and active
4. **Test in sandbox mode** - Switch to sandbox to test without real money:
   ```php
   define('PAYMENT_ENVIRONMENT', 'sandbox');
   define('TOYYIBPAY_API_URL', 'https://dev.toyyibpay.com/index.php/api/');
   ```

---

## Contact Information

**ToyyibPay Support:**
- Website: https://toyyibpay.com
- Email: support@toyyibpay.com
- Phone: Check their website for current contact number

---

## Recent Changes Made

The following improvements were made to help diagnose and fix payment errors:

1. **Enhanced error handling** in `apps/models/ToyyibPay.php`:
   - Better error messages for different failure scenarios
   - Improved logging with masked sensitive data
   - Amount validation before API call

2. **Improved error display** in `apps/checkout.php`:
   - More specific error messages based on error type
   - Better logging of failure details

3. **Created diagnostic tool** at `apps/test-toyyibpay.php`:
   - Tests API connection
   - Validates configuration
   - Creates test bill to verify everything works
   - Provides specific recommendations based on results

---

## Prevention Tips

To avoid payment errors in the future:

1. **Monitor your prepaid balance** - Set up alerts in ToyyibPay
2. **Keep credentials secure** - Don't share your secret key
3. **Test after changes** - Always test checkout after updating configuration
4. **Check logs regularly** - Monitor for any unusual errors
5. **Keep backups** - Backup your configuration files

---

Last Updated: 2025-11-17

