# 🚀 Forgot Password - Quick Start Guide

## ⚡ 3-Step Setup

### 1️⃣ Update Email Password (Required)

Open `apps/config/email.php` and update line 10:

```php
define('SMTP_PASSWORD', 'YOUR_ACTUAL_PASSWORD_HERE');
```

Replace with the actual password for `resetpassword@2dayparfum.com`

### 2️⃣ Run Setup Script (Required)

Visit: **`https://2dayparfum.com/apps/setup-forgot-password.php`**

This will automatically:
- ✅ Create the database table
- ✅ Verify your configuration
- ✅ Check all files

### 3️⃣ Test Email (Recommended)

Visit: **`https://2dayparfum.com/apps/test-email.php`**

- Enter your email
- Click "Send Test Email"
- Check your inbox

---

## 🎯 That's It! You're Ready!

### Test the Complete Flow:

1. Go to: `https://2dayparfum.com/apps/login.php`
2. Click "Forgot Password?"
3. Enter email address
4. Check email for reset link
5. Click link and set new password
6. Login with new password

---

## 📧 Your Email Settings

- **Host:** mail.2dayparfum.com
- **Port:** 465 (SSL)
- **Username:** resetpassword@2dayparfum.com
- **From:** 2 Days Parfume <resetpassword@2dayparfum.com>

---

## 🔗 Quick Links

- **Setup Script:** `/apps/setup-forgot-password.php`
- **Test Email:** `/apps/test-email.php`
- **Forgot Password:** `/apps/forgot-password.php`
- **Login Page:** `/apps/login.php`

---

## 📚 Documentation

- **Full Setup Guide:** `FORGOT_PASSWORD_SETUP.md`
- **Summary:** `FORGOT_PASSWORD_SUMMARY.md`

---

## 🆘 Troubleshooting

**Email not sending?**
1. Check password in `config/email.php`
2. Run `test-email.php` to diagnose
3. Check `error_log` file

**Token expired?**
- Tokens are valid for 1 hour
- Request a new reset link

**Need help?**
- Check `FORGOT_PASSWORD_SETUP.md` for detailed troubleshooting

---

## 💡 Optional: Install PHPMailer

For better email delivery:

```bash
cd c:\Users\azfar\Downloads\apps\apps
composer require phpmailer/phpmailer
```

**Note:** System works without PHPMailer using PHP's mail() function.

---

**Ready to use in 3 steps! 🎉**

