# Perfume Store Admin Panel

A comprehensive admin dashboard for managing your perfume store built with PHP, MySQL, and a clean black and white UI design.

## Features

### 🏠 Dashboard
- Real-time statistics overview
- Revenue charts and analytics
- Recent orders and top products
- Order status distribution
- Low stock alerts

### 📦 Product Management
- Add, edit, and delete products
- Stock quantity management
- Product categories
- Best seller and new arrival flags
- Image upload support
- Bulk operations

### 🛒 Order Management
- View all orders
- Update order status
- Order details with customer information
- Export orders to CSV
- Search and filter orders

### 👥 Customer Management
- View customer list
- Customer details and order history
- Export customer data
- Search and filter customers

### 🖼️ Banner Management
- Upload homepage banners
- Image preview and management
- Support for JPG, PNG, GIF formats
- File size validation (max 5MB)

### 📊 Analytics & Reports
- Revenue trends (12 months)
- Top selling products
- Order status distribution
- Export reports to CSV
- Print functionality

### ⚙️ Settings
- Store information management
- System information display
- Database management tools
- Security settings
- Maintenance mode

## Installation

1. **Upload Files**: Upload the `admin` folder to your web server
2. **Database**: Ensure your database is set up with the provided schema
3. **Permissions**: Make sure the `banner` folder is writable for uploads
4. **Access**: Navigate to `yourdomain.com/admin/`

## Login Credentials

### Demo Accounts
- **Admin**: admin@perfume.com / admin123
- **Owner**: owner@perfume.com / owner123

## File Structure

```
admin/
├── assets/
│   ├── css/
│   │   └── admin.css          # Main stylesheet
│   ├── js/
│   │   └── admin.js           # JavaScript functions
│   └── images/                # Admin images
├── includes/
│   ├── auth.php               # Authentication system
│   └── functions.php          # Admin functions
├── pages/
│   ├── products.php           # Product management
│   ├── orders.php             # Order management
│   ├── customers.php          # Customer management
│   ├── banners.php            # Banner management
│   ├── analytics.php          # Analytics dashboard
│   └── settings.php           # Settings page
├── ajax/
│   ├── update_order_status.php
│   ├── update_product_stock.php
│   └── get_order_details.php
├── index.php                  # Main dashboard
├── login.php                  # Login page
├── logout.php                 # Logout handler
└── README.md                  # This file
```

## Features Overview

### Dashboard
- **Statistics Cards**: Total products, orders, revenue, customers
- **Charts**: Monthly revenue trend, order status distribution
- **Recent Data**: Latest orders and top-selling products
- **Alerts**: Low stock items and pending orders

### Product Management
- **CRUD Operations**: Full create, read, update, delete functionality
- **Stock Management**: Real-time stock updates
- **Categories**: Organize products by categories
- **Search & Filter**: Find products quickly
- **Bulk Actions**: Manage multiple products at once

### Order Management
- **Order Tracking**: View order details and status
- **Status Updates**: Change order status (pending, processing, shipped, delivered, cancelled)
- **Customer Info**: View customer details for each order
- **Export**: Download order data as CSV

### Banner Management
- **Image Upload**: Upload homepage banners
- **Preview**: See banners before publishing
- **File Management**: Delete unwanted banners
- **Validation**: File type and size validation

### Analytics
- **Revenue Charts**: Visual representation of sales data
- **Product Performance**: Top-selling products analysis
- **Order Analytics**: Order status and trends
- **Export Reports**: Download analytics data

## Security Features

- **Admin Authentication**: Secure login system
- **Session Management**: Automatic session timeout
- **Input Validation**: All inputs are validated and sanitized
- **SQL Injection Protection**: Prepared statements used throughout
- **File Upload Security**: File type and size validation

## Browser Support

- Chrome (recommended)
- Firefox
- Safari
- Edge
- Mobile responsive design

## Customization

### Colors
The admin panel uses a black and white color scheme. To customize:
1. Edit `admin/assets/css/admin.css`
2. Modify CSS variables for colors
3. Update chart colors in JavaScript

### Adding New Features
1. Create new pages in `admin/pages/`
2. Add navigation items in sidebar
3. Create AJAX handlers in `admin/ajax/`
4. Update `admin/includes/functions.php` for new functionality

## Troubleshooting

### Common Issues

1. **Login Not Working**
   - Check database connection
   - Verify admin credentials in `admin/includes/auth.php`

2. **Images Not Uploading**
   - Check folder permissions for `banner` directory
   - Verify file size limits in PHP settings

3. **Charts Not Displaying**
   - Ensure Chart.js library is loaded
   - Check browser console for JavaScript errors

4. **Database Errors**
   - Verify database connection settings
   - Check if all required tables exist

### Support

For technical support or feature requests, please contact the development team.

## Version History

- **v1.0.0** - Initial release with core functionality
  - Dashboard with statistics
  - Product management
  - Order management
  - Customer management
  - Banner management
  - Analytics and reporting
  - Settings page

---

**Note**: This admin panel is designed to work with the existing perfume store application. Make sure your main application database is properly configured before using the admin panel.