<?php
require_once '../includes/auth.php';
require_once '../includes/functions.php';

$adminAuth->requireLogin();

header('Content-Type: application/json');

try {
    $action = $_POST['action'] ?? $_GET['action'] ?? '';
    
    switch ($action) {
        case 'add_category':
            $name = trim($_POST['name'] ?? '');
            $slug = trim($_POST['slug'] ?? '');
            $description = trim($_POST['description'] ?? '');
            $image = trim($_POST['image'] ?? '');
            
            if (empty($name) || empty($slug)) {
                echo json_encode(['success' => false, 'message' => 'Name and slug are required']);
                exit;
            }
            
            // Check if slug already exists
            if ($adminFunctions->categorySlugExists($slug)) {
                echo json_encode(['success' => false, 'message' => 'Slug already exists']);
                exit;
            }
            
            $categoryData = [
                'name' => $name,
                'slug' => $slug,
                'description' => $description,
                'image' => $image,
                'is_active' => 1
            ];
            
            if ($adminFunctions->addCategory($categoryData)) {
                echo json_encode(['success' => true, 'message' => 'Category added successfully']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error adding category']);
            }
            break;
            
        case 'edit_category':
            $id = intval($_POST['id'] ?? 0);
            $name = trim($_POST['name'] ?? '');
            $slug = trim($_POST['slug'] ?? '');
            $description = trim($_POST['description'] ?? '');
            $image = trim($_POST['image'] ?? '');
            $is_active = isset($_POST['is_active']) ? 1 : 0;
            
            if (empty($name) || empty($slug) || $id <= 0) {
                echo json_encode(['success' => false, 'message' => 'Invalid data provided']);
                exit;
            }
            
            // Check if slug already exists (excluding current category)
            if ($adminFunctions->categorySlugExists($slug, $id)) {
                echo json_encode(['success' => false, 'message' => 'Slug already exists']);
                exit;
            }
            
            $categoryData = [
                'name' => $name,
                'slug' => $slug,
                'description' => $description,
                'image' => $image,
                'is_active' => $is_active
            ];
            
            if ($adminFunctions->updateCategory($id, $categoryData)) {
                echo json_encode(['success' => true, 'message' => 'Category updated successfully']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error updating category']);
            }
            break;
            
        case 'delete_category':
            $id = intval($_POST['id'] ?? 0);
            
            if ($id <= 0) {
                echo json_encode(['success' => false, 'message' => 'Invalid category ID']);
                exit;
            }
            
            if ($adminFunctions->deleteCategory($id)) {
                echo json_encode(['success' => true, 'message' => 'Category deleted successfully']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error deleting category']);
            }
            break;
            
        case 'update_order':
            $input = file_get_contents('php://input');
            $data = json_decode($input, true);
            
            if (!isset($data['categories']) || !is_array($data['categories'])) {
                echo json_encode(['success' => false, 'message' => 'Invalid order data']);
                exit;
            }
            
            if ($adminFunctions->updateCategoryOrder($data['categories'])) {
                echo json_encode(['success' => true, 'message' => 'Category order updated successfully']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error updating category order']);
            }
            break;
            
        default:
            echo json_encode(['success' => false, 'message' => 'Invalid action']);
            break;
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Server error: ' . $e->getMessage()]);
}
?>