<?php
require_once '../includes/auth.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

$adminFunctions = new AdminFunctions();
$action = $_GET['action'] ?? '';

try {
    switch ($action) {
        case 'delete':
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                throw new Exception('Invalid request method');
            }
            
            $reviewId = (int)($_POST['review_id'] ?? 0);
            
            if (!$reviewId) {
                throw new Exception('Invalid review ID');
            }
            
            if ($adminFunctions->deleteReview($reviewId)) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Review deleted successfully!'
                ]);
            } else {
                throw new Exception('Failed to delete review');
            }
            break;
            
        default:
            throw new Exception('Invalid action');
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>