<?php
require_once '../includes/auth.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

$adminAuth->requireLogin();

$orderId = $_GET['id'] ?? null;

if ($orderId) {
    $order = $adminFunctions->getOrderById($orderId);
    $orderItems = $adminFunctions->getOrderItems($orderId);
    
    if ($order) {
        ob_start();
        ?>
        <div class="order-details">
            <div class="order-header">
                <h4>Order #<?php echo $order['id']; ?></h4>
                <?php
                // Use same logic as order-success page to determine display status
                $display_order_status = $order['status'];
                $payment_status = $order['payment_status'] ?? 'pending';
                
                // If payment is successful, show processing status
                if ($payment_status === 'paid' && $order['status'] === 'awaiting_payment') {
                    $display_order_status = 'processing';
                }
                ?>
                <span class="status status-<?php echo $display_order_status; ?>">
                    <?php echo ucfirst(str_replace('_', ' ', $display_order_status)); ?>
                </span>
            </div>
            
            <div class="order-info">
                <div class="info-section">
                    <h5>Customer Information</h5>
                    <p><strong>Name:</strong> <?php echo htmlspecialchars($order['first_name'] . ' ' . $order['last_name']); ?></p>
                    <p><strong>Email:</strong> <?php echo htmlspecialchars($order['email']); ?></p>
                    <p><strong>Phone:</strong> <?php echo htmlspecialchars($order['phone']); ?></p>
                </div>
                
                <div class="info-section">
                    <h5>Shipping Address</h5>
                    <p><?php echo htmlspecialchars($order['address']); ?></p>
                    <p><?php echo htmlspecialchars($order['city'] . ', ' . $order['state'] . ' ' . $order['zip_code']); ?></p>
                    <p><?php echo htmlspecialchars($order['country']); ?></p>
                </div>
                
                <div class="info-section">
                    <h5>Order Details</h5>
                    <p><strong>Order Number:</strong> <?php echo htmlspecialchars($order['order_number'] ?? 'N/A'); ?></p>
                    <p><strong>Order Date:</strong> <?php echo date('M j, Y H:i', strtotime($order['created_at'])); ?></p>
                    <p><strong>Status:</strong> 
                        <span class="status status-<?php echo $display_order_status; ?>">
                            <?php echo ucfirst(str_replace('_', ' ', $display_order_status)); ?>
                        </span>
                    </p>
                    <p><strong>Payment Method:</strong> <?php echo htmlspecialchars($order['payment_method']); ?></p>
                    <p><strong>Payment Status:</strong> 
                        <span class="status status-<?php echo $payment_status; ?>">
                            <?php echo ucfirst($payment_status); ?>
                        </span>
                    </p>
                    <?php if (!empty($order['tracking_number'])): ?>
                    <p><strong>Tracking Number:</strong> 
                        <span class="tracking-number"><?php echo htmlspecialchars($order['tracking_number']); ?></span>
                    </p>
                    <?php endif; ?>
                    <p><strong>Total Amount:</strong> RM <?php echo number_format($order['total'], 2); ?></p>
                </div>
            </div>
            
            <div class="order-items">
                <h5>Order Items</h5>
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th>Quantity</th>
                            <th>Price</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($orderItems as $item): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($item['product_name']); ?></td>
                            <td><?php echo $item['quantity']; ?></td>
                            <td>RM <?php echo number_format($item['price'], 2); ?></td>
                            <td>RM <?php echo number_format($item['subtotal'], 2); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php
        $html = ob_get_clean();
        
        echo json_encode(['success' => true, 'html' => $html]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Order not found']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Order ID required']);
}
?>