<?php
require_once '../includes/auth.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

$adminAuth->requireLogin();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Support JSON or form-encoded payloads
    $raw = file_get_contents('php://input');
    $input = json_decode($raw, true);
    if (!is_array($input) || empty($input)) {
        $input = $_POST; // fallback for form-encoded
    }
    
    $productId = isset($input['product_id']) ? (int)$input['product_id'] : null;
    $stock = isset($input['stock']) ? (int)$input['stock'] : null;
    
    if ($productId && $stock !== null) {
        if ($adminFunctions->updateProductStock($productId, $stock)) {
            echo json_encode(['success' => true, 'message' => 'Product stock updated successfully']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update product stock']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>