<?php
/**
 * Cron job to automatically expire flash sales that have passed their duration
 * Run this script every hour via cron: 0 * * * * php /path/to/expire-flash-sales.php
 */

require_once '../includes/functions.php';

try {
    $pdo = getDB();
    
    // Find and expire flash sales that have passed their duration
    $stmt = $pdo->prepare("
        UPDATE products 
        SET is_flash_sale = 0, 
            sale_price = NULL, 
            is_on_sale = 0,
            flash_sale_started_at = NULL
        WHERE is_flash_sale = 1 
        AND flash_sale_started_at IS NOT NULL
        AND TIMESTAMPDIFF(HOUR, flash_sale_started_at, NOW()) >= flash_sale_duration_hours
    ");
    
    $stmt->execute();
    $expiredCount = $stmt->rowCount();
    
    if ($expiredCount > 0) {
        error_log("Flash Sale Expiry: $expiredCount flash sales expired automatically");
    }
    
    echo "Flash sale expiry check completed. $expiredCount sales expired.\n";
    
} catch (Exception $e) {
    error_log("Flash Sale Expiry Error: " . $e->getMessage());
    echo "Error: " . $e->getMessage() . "\n";
}
?>