<?php
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

$adminAuth->requireLogin();

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid customer ID']);
    exit;
}

$customerId = (int)$_GET['id'];

try {
    $adminFunctions = new AdminFunctions();
    $customer = $adminFunctions->getCustomerById($customerId);
    
    if (!$customer) {
        echo json_encode(['success' => false, 'message' => 'Customer not found']);
        exit;
    }
    
    // Get customer orders
    $orders = $adminFunctions->getCustomerOrders($customerId);
    
    // Get customer loyalty points
    $loyaltyPoints = $adminFunctions->getCustomerLoyaltyPoints($customerId);
    
    // Generate HTML content
    $html = '
    <div class="customer-details">
        <div class="customer-header">
            <div class="customer-avatar">
                <img src="../../' . htmlspecialchars($customer['avatar'] ?? 'images/placeholder.svg') . '" alt="Customer Avatar" style="width: 80px; height: 80px; border-radius: 50%; object-fit: cover;">
            </div>
            <div class="customer-info">
                <h3>' . htmlspecialchars($customer['first_name'] . ' ' . $customer['last_name']) . '</h3>
                <p><strong>Email:</strong> ' . htmlspecialchars($customer['email']) . '</p>
                <p><strong>Phone:</strong> ' . htmlspecialchars($customer['phone'] ?? 'N/A') . '</p>
                <p><strong>Loyalty Points:</strong> ' . $loyaltyPoints . '</p>
                <p><strong>Member Since:</strong> ' . date('M d, Y', strtotime($customer['created_at'])) . '</p>
            </div>
        </div>
        
        <div class="customer-orders">
            <h4>Recent Orders (' . count($orders) . ')</h4>
            <div class="orders-list">';
    
    if (empty($orders)) {
        $html .= '<p>No orders found.</p>';
    } else {
        foreach ($orders as $order) {
            $statusClass = strtolower(str_replace(' ', '-', $order['status']));
            $html .= '
                <div class="order-item">
                    <div class="order-info">
                        <strong>Order #' . $order['id'] . '</strong>
                        <span class="order-status status-' . $statusClass . '">' . ucfirst($order['status']) . '</span>
                    </div>
                    <div class="order-details">
                        <p>Date: ' . date('M d, Y', strtotime($order['created_at'])) . '</p>
                        <p>Total: RM ' . number_format($order['total'] ?? $order['total_amount'] ?? 0, 2) . '</p>
                    </div>
                </div>';
        }
    }
    
    $html .= '
            </div>
        </div>
    </div>';
    
    echo json_encode(['success' => true, 'html' => $html]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>