<?php
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

$adminAuth->requireLogin();

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid customer ID']);
    exit;
}

$customerId = (int)$_GET['id'];

try {
    $adminFunctions = new AdminFunctions();
    $orders = $adminFunctions->getCustomerOrders($customerId);
    
    // Generate HTML content for orders
    $html = '<div class="customer-orders-list">';
    
    if (empty($orders)) {
        $html .= '<p>No orders found for this customer.</p>';
    } else {
        foreach ($orders as $order) {
            $statusClass = strtolower(str_replace(' ', '-', $order['status']));
            $html .= '
                <div class="order-card">
                    <div class="order-header">
                        <h4>Order #' . $order['id'] . '</h4>
                        <span class="order-status status-' . $statusClass . '">' . ucfirst($order['status']) . '</span>
                    </div>
                    <div class="order-body">
                        <p><strong>Date:</strong> ' . date('M d, Y H:i', strtotime($order['created_at'])) . '</p>
                        <p><strong>Total:</strong> RM ' . number_format($order['total'] ?? $order['total_amount'] ?? 0, 2) . '</p>
                        <p><strong>Payment Method:</strong> ' . htmlspecialchars($order['payment_method'] ?? 'N/A') . '</p>
                        <p><strong>Shipping Address:</strong> ' . htmlspecialchars($order['shipping_address'] ?? 'N/A') . '</p>
                    </div>
                </div>';
        }
    }
    
    $html .= '</div>';
    
    echo json_encode(['success' => true, 'html' => $html]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>