<?php
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

$adminAuth->requireLogin();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $orderId = $_POST['order_id'] ?? null;
    
    if (!$orderId) {
        echo json_encode([
            'success' => false,
            'message' => 'Order ID is required'
        ]);
        exit;
    }
    
    // Get order details
    $order = $adminFunctions->getOrderById($orderId);
    
    if (!$order) {
        echo json_encode([
            'success' => false,
            'message' => 'Order not found'
        ]);
        exit;
    }
    
    // Check if order is delivered
    if ($order['status'] !== 'delivered') {
        echo json_encode([
            'success' => false,
            'message' => 'Order is not delivered yet'
        ]);
        exit;
    }
    
    // Get customer email
    $shipping_address = json_decode($order['shipping_address'], true);
    $customerEmail = $shipping_address['email'] ?? null;
    
    if (!$customerEmail) {
        echo json_encode([
            'success' => false,
            'message' => 'Customer email not found'
        ]);
        exit;
    }
    
    // Send delivery confirmation email
    $subject = "Order Delivered - " . $order['order_number'];
    $message = "
    <html>
    <head>
        <title>Order Delivered</title>
    </head>
    <body>
        <h2>Your Order Has Been Delivered!</h2>
        <p>Dear " . htmlspecialchars($shipping_address['first_name'] . ' ' . $shipping_address['last_name']) . ",</p>
        
        <p>Great news! Your order #" . $order['order_number'] . " has been successfully delivered.</p>
        
        <h3>Order Details:</h3>
        <ul>
            <li><strong>Order Number:</strong> " . $order['order_number'] . "</li>
            <li><strong>Total Amount:</strong> RM " . number_format($order['total'], 2) . "</li>
            <li><strong>Delivery Date:</strong> " . date('M j, Y', strtotime($order['updated_at'])) . "</li>
        </ul>
        
        <p>Thank you for choosing 2 Days Parfume! We hope you enjoy your purchase.</p>
        
        <p>If you have any questions or concerns, please don't hesitate to contact us.</p>
        
        <p>Best regards,<br>
        2 Days Parfume Team</p>
    </body>
    </html>
    ";
    
    $headers = [
        'MIME-Version: 1.0',
        'Content-type: text/html; charset=UTF-8',
        'From: 2 Days Parfume <noreply@2daysparfume.com>',
        'Reply-To: support@2daysparfume.com',
        'X-Mailer: PHP/' . phpversion()
    ];
    
    $mailSent = mail($customerEmail, $subject, $message, implode("\r\n", $headers));
    
    if ($mailSent) {
        echo json_encode([
            'success' => true,
            'message' => 'Delivery confirmation email sent successfully'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Failed to send email. Please check your mail configuration.'
        ]);
    }
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid request method'
    ]);
}
?>