<?php
session_start();
require_once '../includes/auth-check.php';
require_once '../config/database.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] === 'guest') {
    echo json_encode(['success' => false, 'message' => 'Please login to view favorites']);
    exit;
}

try {
    $conn = getDB();
    $user_id = $_SESSION['user_id'];
    
    // Get favorite product IDs for the current user
    $stmt = $conn->prepare("SELECT product_id FROM wishlist WHERE user_id = ? ORDER BY created_at DESC");
    $stmt->execute([$user_id]);
    $favorite_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    $favoriteProducts = [];
    
    if (!empty($favorite_ids)) {
        // Get product details for favorite products
        $placeholders = str_repeat('?,', count($favorite_ids) - 1) . '?';
        $stmt = $conn->prepare("SELECT * FROM products WHERE id IN ($placeholders) AND is_active = 1");
        $stmt->execute($favorite_ids);
        $favoriteProducts = $stmt->fetchAll();
    }
    
    echo json_encode([
        'success' => true,
        'products' => $favoriteProducts,
        'count' => count($favoriteProducts)
    ]);
    
} catch (Exception $e) {
    error_log("Error getting favorites: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'An error occurred']);
}
?>