<?php
session_start();
require_once '../models/Order.php';
require_once '../includes/remember-me.php';

// Check for remember me token and auto-login
checkRememberMe();

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] === 'guest') {
    echo json_encode([
        'success' => false,
        'message' => 'User not logged in'
    ]);
    exit();
}

$order = new Order();
$user_orders = $order->getUserOrders($_SESSION['user_id']);

// Get the last update timestamp from the request
$last_update = $_GET['last_update'] ?? null;

// Filter orders that have been updated since the last check
$updated_orders = [];
if ($last_update) {
    $last_update_time = strtotime($last_update);
    foreach ($user_orders as $order_data) {
        $order_update_time = strtotime($order_data['updated_at']);
        if ($order_update_time > $last_update_time) {
            $updated_orders[] = [
                'id' => $order_data['id'],
                'order_number' => $order_data['order_number'],
                'status' => $order_data['status'],
                'updated_at' => $order_data['updated_at'],
                'total' => $order_data['total']
            ];
        }
    }
}

// Get order counts by status
$order_counts = [
    'pending' => 0,
    'processing' => 0,
    'delivered' => 0,
    'cancelled' => 0
];

foreach ($user_orders as $order_data) {
    switch ($order_data['status']) {
        case 'pending':
        case 'awaiting_payment':
            $order_counts['pending']++;
            break;
        case 'processing':
        case 'shipped':
            $order_counts['processing']++;
            break;
        case 'delivered':
            $order_counts['delivered']++;
            break;
        case 'cancelled':
            $order_counts['cancelled']++;
            break;
    }
}

echo json_encode([
    'success' => true,
    'updated_orders' => $updated_orders,
    'order_counts' => $order_counts,
    'current_time' => date('Y-m-d H:i:s'),
    'has_updates' => !empty($updated_orders)
]);
?>