<?php
session_start();
require_once '../includes/auth-check.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'User not logged in']);
    exit;
}

try {
    // Clear applied voucher from session
    unset($_SESSION['applied_voucher']);
    
    echo json_encode(['success' => true, 'message' => 'Voucher removed successfully']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error removing voucher: ' . $e->getMessage()]);
}
?>