<?php
session_start();
require_once __DIR__ . '/../models/User.php';

header('Content-Type: text/plain; charset=utf-8');

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($id <= 0) {
    http_response_code(400);
    echo 'Invalid user';
    exit();
}

$user = new User();
$data = $user->getById($id);

if (!$data) {
    http_response_code(404);
    echo 'Not found';
    exit();
}

$fullName = trim(($data['first_name'] ?? '') . ' ' . ($data['last_name'] ?? ''));
echo $fullName !== '' ? $fullName : 'Customer';
exit();
?>


