<?php
/**
 * Database Configuration
 * Update these settings according to your database setup
 */

// Database configuration
define('DB_HOST', 'igold-vps.com');
define('DB_NAME', 'igoldvps_perfume2days');
define('DB_USER', 'igoldvps_perfume2days');
define('DB_PASS', 'Condition5594.');
define('DB_CHARSET', 'utf8mb4');

class Database {
    private $host = DB_HOST;
    private $db_name = DB_NAME;
    private $username = DB_USER;
    private $password = DB_PASS;
    private $charset = DB_CHARSET;
    private $conn;

    /**
     * Get database connection
     */
    public function getConnection() {
        $this->conn = null;

        try {
            $dsn = "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=" . $this->charset;
            $this->conn = new PDO($dsn, $this->username, $this->password);
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        } catch(PDOException $exception) {
            echo "Connection error: " . $exception->getMessage();
        }

        return $this->conn;
    }

    /**
     * Test database connection
     */
    public function testConnection() {
        try {
            $conn = $this->getConnection();
            if ($conn) {
                return true;
            }
        } catch(Exception $e) {
            return false;
        }
        return false;
    }
}

// Global database connection function
function getDB() {
    $database = new Database();
    return $database->getConnection();
}

// Test connection on include
try {
    $db = getDB();
    if (!$db) {
        throw new Exception("Database connection failed");
    }
} catch(Exception $e) {
    // Log error or show user-friendly message
    error_log("Database connection error: " . $e->getMessage());
}
?>