<?php
/**
 * Email Configuration
 * SMTP settings for sending emails
 */

// Email settings based on your mail client configuration
define('SMTP_HOST', 'mail.2dayparfum.com');
define('SMTP_PORT', 465); // SSL port
define('SMTP_USERNAME', 'resetpassword@2dayparfum.com');
define('SMTP_PASSWORD', 'Use the email account\'s password'); // You need to set the actual password
define('SMTP_ENCRYPTION', 'ssl'); // Use 'ssl' for port 465, 'tls' for port 587
define('SMTP_FROM_EMAIL', 'resetpassword@2dayparfum.com');
define('SMTP_FROM_NAME', '2 Days Parfume');

// Alternative SMTP settings (if using port 993 for IMAP)
// For sending, typically use port 465 (SSL) or 587 (TLS)
// define('SMTP_PORT', 587); // TLS port
// define('SMTP_ENCRYPTION', 'tls');

/**
 * Send email using PHPMailer
 * 
 * @param string $to Recipient email address
 * @param string $subject Email subject
 * @param string $body Email body (HTML)
 * @param string $altBody Plain text alternative body
 * @return array ['success' => bool, 'message' => string]
 */
function sendEmail($to, $subject, $body, $altBody = '') {
    // Check if PHPMailer is available
    if (!class_exists('PHPMailer\PHPMailer\PHPMailer')) {
        // Try to load PHPMailer via composer autoload
        if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
            require_once __DIR__ . '/../vendor/autoload.php';
        } else {
            // Fallback to basic mail() function
            return sendEmailBasic($to, $subject, $body);
        }
    }
    
    try {
        $mail = new PHPMailer\PHPMailer\PHPMailer(true);
        
        // Server settings
        $mail->isSMTP();
        $mail->Host       = SMTP_HOST;
        $mail->SMTPAuth   = true;
        $mail->Username   = SMTP_USERNAME;
        $mail->Password   = SMTP_PASSWORD;
        $mail->SMTPSecure = SMTP_ENCRYPTION;
        $mail->Port       = SMTP_PORT;
        
        // Recipients
        $mail->setFrom(SMTP_FROM_EMAIL, SMTP_FROM_NAME);
        $mail->addAddress($to);
        $mail->addReplyTo(SMTP_FROM_EMAIL, SMTP_FROM_NAME);
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $body;
        $mail->AltBody = $altBody ?: strip_tags($body);
        
        $mail->send();
        
        return [
            'success' => true,
            'message' => 'Email sent successfully'
        ];
    } catch (Exception $e) {
        error_log("Email sending failed: " . $e->getMessage());
        
        return [
            'success' => false,
            'message' => 'Email could not be sent. Error: ' . $e->getMessage()
        ];
    }
}

/**
 * Fallback email function using PHP's mail()
 * 
 * @param string $to Recipient email address
 * @param string $subject Email subject
 * @param string $body Email body (HTML)
 * @return array ['success' => bool, 'message' => string]
 */
function sendEmailBasic($to, $subject, $body) {
    $headers = [
        'MIME-Version: 1.0',
        'Content-type: text/html; charset=UTF-8',
        'From: ' . SMTP_FROM_NAME . ' <' . SMTP_FROM_EMAIL . '>',
        'Reply-To: ' . SMTP_FROM_EMAIL,
        'X-Mailer: PHP/' . phpversion()
    ];
    
    $mailSent = mail($to, $subject, $body, implode("\r\n", $headers));
    
    if ($mailSent) {
        return [
            'success' => true,
            'message' => 'Email sent successfully'
        ];
    } else {
        return [
            'success' => false,
            'message' => 'Failed to send email. Please check your mail configuration.'
        ];
    }
}

/**
 * Generate password reset email template
 * 
 * @param string $userName User's name
 * @param string $resetLink Password reset link
 * @return string HTML email template
 */
function getPasswordResetEmailTemplate($userName, $resetLink) {
    return '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Password Reset</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                line-height: 1.6;
                color: #333;
                max-width: 600px;
                margin: 0 auto;
                padding: 20px;
            }
            .container {
                background-color: #f9f9f9;
                border-radius: 10px;
                padding: 30px;
                box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            }
            .header {
                text-align: center;
                margin-bottom: 30px;
            }
            .logo {
                max-width: 150px;
                margin-bottom: 20px;
            }
            h1 {
                color: #2c3e50;
                font-size: 24px;
                margin-bottom: 20px;
            }
            .content {
                background-color: white;
                padding: 25px;
                border-radius: 8px;
                margin-bottom: 20px;
            }
            .button {
                display: inline-block;
                padding: 12px 30px;
                background-color: #3498db;
                color: white;
                text-decoration: none;
                border-radius: 5px;
                margin: 20px 0;
                font-weight: bold;
            }
            .button:hover {
                background-color: #2980b9;
            }
            .footer {
                text-align: center;
                font-size: 12px;
                color: #7f8c8d;
                margin-top: 20px;
            }
            .warning {
                background-color: #fff3cd;
                border-left: 4px solid #ffc107;
                padding: 15px;
                margin: 20px 0;
                border-radius: 4px;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>🔐 Password Reset Request</h1>
            </div>
            
            <div class="content">
                <p>Hello ' . htmlspecialchars($userName) . ',</p>
                
                <p>We received a request to reset your password for your 2 Days Parfume account.</p>
                
                <p>Click the button below to reset your password:</p>
                
                <div style="text-align: center;">
                    <a href="' . htmlspecialchars($resetLink) . '" class="button">Reset Password</a>
                </div>
                
                <p>Or copy and paste this link into your browser:</p>
                <p style="word-break: break-all; color: #3498db;">' . htmlspecialchars($resetLink) . '</p>
                
                <div class="warning">
                    <strong>⚠️ Important:</strong>
                    <ul style="margin: 10px 0;">
                        <li>This link will expire in 1 hour</li>
                        <li>If you didn\'t request this reset, please ignore this email</li>
                        <li>Your password will remain unchanged until you create a new one</li>
                    </ul>
                </div>
            </div>
            
            <div class="footer">
                <p>This is an automated email from 2 Days Parfume. Please do not reply to this email.</p>
                <p>If you need assistance, contact us at support@2daysparfume.com</p>
                <p>&copy; ' . date('Y') . ' 2 Days Parfume. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>
    ';
}

