<?php
/**
 * Payment Configuration
 * toyyibPay Integration Settings
 */

define('TOYYIBPAY_USER_SECRET_KEY', 'kr6idbeg-vfqe-cx1v-6p7p-bpdjmec4c2dk'); // Production secret key
define('TOYYIBPAY_CATEGORY_CODE', '93v503tu'); // Production category code (update this with your production category)
define('TOYYIBPAY_API_URL', 'https://toyyibpay.com/index.php/api/'); // Production API

// Payment URLs
define('TOYYIBPAY_RETURN_URL', 'https://2dayparfum.com/apps/payment-return.php'); // Production return URL
define('TOYYIBPAY_CALLBACK_URL', 'https://2dayparfum.com/apps/payment-callback.php'); // Production callback URL

// Payment Settings
define('TOYYIBPAY_BILL_EXPIRY_DAYS', 3); // Bill expires in 3 days
define('TOYYIBPAY_PAYMENT_CHANNEL', '2'); // 0=FPX, 1=Credit Card, 2=Both

// Environment (development/production)
define('PAYMENT_ENVIRONMENT', 'production'); // PRODUCTION MODE

// Payment method mapping
$payment_methods = [
    'toyyibpay_fpx' => 'FPX Online Banking',
    'toyyibpay_card' => 'Credit/Debit Card',
    'toyyibpay_both' => 'FPX & Credit Card',
    'cod' => 'Cash on Delivery',
    'bank_transfer' => 'Bank Transfer'
];

// Get payment method name
function getPaymentMethodName($method) {
    global $payment_methods;
    return $payment_methods[$method] ?? $method;
}

// Check if payment method is toyyibPay
function isToyyibPayMethod($method) {
    return strpos($method, 'toyyibpay_') === 0;
}
?>