<?php
session_start();
require_once 'includes/remember-me.php';

// Check for remember me token and auto-login
checkRememberMe();

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] === 'guest') {
    header('Location: login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Service - 2 Days Parfume</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="script.js" defer></script>
    <style>
        .customer-service-container {
            min-height: 100vh;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding-bottom: 100px;
        }

        .service-header {
            background: linear-gradient(135deg, #1A4D2A 0%, #2d5a3d 50%, #1A4D2A 100%);
            padding: 20px 20px 30px 20px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .service-header::before {
            content: '';
            position: absolute;
            bottom: -20px;
            left: 0;
            right: 0;
            height: 40px;
            background: linear-gradient(135deg, #1A4D2A 0%, #2d5a3d 50%, #1A4D2A 100%);
            border-radius: 50% 50% 0 0 / 100% 100% 0 0;
        }

        .service-title {
            color: #D4AF37;
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .service-subtitle {
            color: #F4D03F;
            font-size: 14px;
        }

        .service-content {
            padding: 30px 20px;
            margin-top: -20px;
            position: relative;
            z-index: 2;
        }

        .service-card {
            background: white;
            border-radius: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            overflow: hidden;
        }

        .service-card-header {
            background: linear-gradient(135deg, #1A4D2A 0%, #2d5a3d 100%);
            color: white;
            padding: 20px;
            text-align: center;
        }

        .service-card-header h3 {
            margin: 0;
            font-size: 18px;
            font-weight: 600;
        }

        .service-card-content {
            padding: 20px;
        }

        .contact-methods {
            display: grid;
            gap: 15px;
        }

        .contact-method {
            display: flex;
            align-items: center;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 10px;
            border: 2px solid transparent;
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .contact-method:hover {
            border-color: #1A4D2A;
            background: #e8f5e8;
        }

        .contact-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            font-size: 20px;
            color: white;
        }

        .contact-icon.whatsapp {
            background: linear-gradient(135deg, #25D366, #128C7E);
        }

        .contact-icon.phone {
            background: linear-gradient(135deg, #1A4D2A, #2d5a3d);
        }

        .contact-icon.email {
            background: linear-gradient(135deg, #D4AF37, #F4D03F);
        }

        .contact-icon.live-chat {
            background: linear-gradient(135deg, #e83e8c, #fd7e14);
        }

        .contact-details {
            flex: 1;
        }

        .contact-title {
            font-size: 16px;
            font-weight: 600;
            color: #1A4D2A;
            margin-bottom: 5px;
        }

        .contact-info {
            font-size: 14px;
            color: #666;
        }

        .contact-action {
            font-size: 12px;
            color: #1A4D2A;
            font-weight: 500;
        }

        .faq-section {
            margin-top: 20px;
        }

        .faq-item {
            border: 1px solid #e9ecef;
            border-radius: 10px;
            margin-bottom: 10px;
            overflow: hidden;
        }

        .faq-question {
            background: #f8f9fa;
            padding: 15px;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-weight: 600;
            color: #1A4D2A;
            transition: background 0.3s ease;
        }

        .faq-question:hover {
            background: #e8f5e8;
        }

        .faq-question.active {
            background: #1A4D2A;
            color: white;
        }

        .faq-answer {
            padding: 0 15px;
            max-height: 0;
            overflow: hidden;
            transition: all 0.3s ease;
            background: white;
        }

        .faq-answer.active {
            padding: 15px;
            max-height: 200px;
        }

        .faq-icon {
            transition: transform 0.3s ease;
        }

        .faq-question.active .faq-icon {
            transform: rotate(180deg);
        }

        .business-hours {
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            padding: 20px;
            border-radius: 10px;
            margin-top: 20px;
        }

        .business-hours h4 {
            color: #1A4D2A;
            margin-bottom: 15px;
            font-size: 16px;
        }

        .hours-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
        }

        .hours-item:last-child {
            border-bottom: none;
        }

        .hours-day {
            font-weight: 600;
            color: #333;
        }

        .hours-time {
            color: #666;
        }

        .response-time {
            background: linear-gradient(135deg, #D4AF37, #F4D03F);
            color: white;
            padding: 15px;
            border-radius: 10px;
            text-align: center;
            margin-top: 20px;
        }

        .response-time h4 {
            margin: 0 0 5px 0;
            font-size: 16px;
        }

        .response-time p {
            margin: 0;
            font-size: 14px;
            opacity: 0.9;
        }
    </style>
</head>
<body>
    <div class="customer-service-container">
        <!-- Top Navigation -->
        <nav class="top-nav">
            <div class="nav-left">
                <i class="fas fa-arrow-left" onclick="goBack()"></i>
            </div>
            <div class="nav-center">
                <div class="logo">
                    <img src="images/LOGO.png" alt="2 Days Parfume Logo" class="logo-img">
                </div>
            </div>
            <div class="nav-right">
                <i class="fas fa-search" onclick="window.location.href='products.php'"></i>
            </div>
        </nav>

        <!-- Service Header -->
        <div class="service-header">
            <div class="service-title">Customer Service</div>
            <div class="service-subtitle">We're here to help you 24/7</div>
        </div>

        <!-- Service Content -->
        <div class="service-content">
            <!-- Contact Methods Card -->
            <div class="service-card">
                <div class="service-card-header">
                    <h3><i class="fas fa-headset"></i> Contact Us</h3>
                </div>
                <div class="service-card-content">
                    <div class="contact-methods">
                        <div class="contact-method" onclick="openWhatsApp()">
                            <div class="contact-icon whatsapp">
                                <i class="fab fa-whatsapp"></i>
                            </div>
                            <div class="contact-details">
                                <div class="contact-title">WhatsApp</div>
                                <div class="contact-info">+60172053153</div>
                                <div class="contact-action">Tap to chat instantly</div>
                            </div>
                        </div>

                        <div class="contact-method" onclick="makePhoneCall()">
                            <div class="contact-icon phone">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="contact-details">
                                <div class="contact-title">Phone Call</div>
                                <div class="contact-info">+60172053153</div>
                                <div class="contact-action">Tap to call now</div>
                            </div>
                        </div>

                        <div class="contact-method" onclick="sendEmail()">
                            <div class="contact-icon email">
                                <i class="fas fa-envelope"></i>
                            </div>
                            <div class="contact-details">
                                <div class="contact-title">Email Support</div>
                                <div class="contact-info">support@2daysparfume.com</div>
                                <div class="contact-action">Tap to send email</div>
                            </div>
                        </div>

                        <div class="contact-method" onclick="startLiveChat()">
                            <div class="contact-icon live-chat">
                                <i class="fas fa-comments"></i>
                            </div>
                            <div class="contact-details">
                                <div class="contact-title">Live Chat</div>
                                <div class="contact-info">Available 24/7</div>
                                <div class="contact-action">Tap to start chat</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            

            <!-- Business Hours Card -->
            <div class="service-card">
                <div class="service-card-header">
                    <h3><i class="fas fa-clock"></i> Business Hours</h3>
                </div>
                <div class="service-card-content">
                    <div class="business-hours">
                        <h4>Customer Service Hours</h4>
                        <div class="hours-item">
                            <span class="hours-day">Monday - Friday</span>
                            <span class="hours-time">9:00 AM - 6:00 PM</span>
                        </div>
                        <div class="hours-item">
                            <span class="hours-day">Saturday</span>
                            <span class="hours-time">9:00 AM - 4:00 PM</span>
                        </div>
                        <div class="hours-item">
                            <span class="hours-day">Sunday</span>
                            <span class="hours-time">Closed</span>
                        </div>
                    </div>

                    <div class="response-time">
                        <h4><i class="fas fa-bolt"></i> Quick Response</h4>
                        <p>WhatsApp: Instant response<br>
                        Email: Within 2 hours<br>
                        Phone: Immediate assistance</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom Navigation -->
        <nav class="bottom-nav">
            <div class="nav-item" onclick="window.location.href='index.php'">
                <i class="fas fa-home"></i>
                
            </div>
            <div class="nav-item" onclick="window.location.href='products.php'">
                <i class="fas fa-box"></i>
               
            </div>
            <div class="nav-item" onclick="window.location.href='cart.php'">
                <i class="fas fa-shopping-cart"></i>
                
            </div>
            <div class="nav-item" onclick="window.location.href='profile.php'">
                <i class="fas fa-user"></i>
                
            </div>
        </nav>
    </div>

    <script>
        function goBack() {
            if (window.history.length > 1) {
                window.history.back();
            } else {
                window.location.href = 'profile.php';
            }
        }

        function openWhatsApp() {
            const phoneNumber = '6017205315'; // Remove + and spaces
            const message = 'Hi! I need help with my order from 2 Days Parfume.';
            const url = `https://wa.me/${phoneNumber}?text=${encodeURIComponent(message)}`;
            window.open(url, '_blank');
        }

        function makePhoneCall() {
            const phoneNumber = '+60312345678';
            window.location.href = `tel:${phoneNumber}`;
        }

        function sendEmail() {
            const email = 'support@2daysparfume.com';
            const subject = 'Customer Service Inquiry';
            const body = 'Hi, I need assistance with...';
            const url = `mailto:${email}?subject=${encodeURIComponent(subject)}&body=${encodeURIComponent(body)}`;
            window.location.href = url;
        }

        function startLiveChat() {
            showNotification('Live chat feature coming soon! For immediate assistance, please use WhatsApp.', 'info');
        }

        function toggleFAQ(element) {
            const answer = element.nextElementSibling;
            const isActive = element.classList.contains('active');

            // Close all other FAQs
            document.querySelectorAll('.faq-question').forEach(q => {
                q.classList.remove('active');
                q.nextElementSibling.classList.remove('active');
            });

            // Toggle current FAQ
            if (!isActive) {
                element.classList.add('active');
                answer.classList.add('active');
            }
        }

        function showNotification(message, type = 'info') {
            const notification = document.createElement('div');
            notification.style.cssText = `
                position: fixed;
                top: 20px;
                left: 50%;
                transform: translateX(-50%);
                background: ${type === 'info' ? '#1A4D2A' : type === 'success' ? '#28a745' : '#dc3545'};
                color: white;
                padding: 15px 20px;
                border-radius: 8px;
                font-size: 14px;
                z-index: 10000;
                box-shadow: 0 4px 12px rgba(0,0,0,0.2);
                max-width: 90%;
                text-align: center;
            `;
            notification.textContent = message;
            document.body.appendChild(notification);

            setTimeout(() => {
                if (notification.parentNode) {
                    notification.parentNode.removeChild(notification);
                }
            }, 4000);
        }

        // Initialize page
        document.addEventListener('DOMContentLoaded', function() {
            // Add any initialization code here
        });
    </script>
</body>
</html>