-- Create notification_logs table for storing push notification history
CREATE TABLE IF NOT EXISTS notification_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    body TEXT NOT NULL,
    target VARCHAR(100) NOT NULL COMMENT 'all, user_id, or group',
    admin_name VARCHAR(100) NULL COMMENT 'Admin who sent the notification',
    success TINYINT(1) NOT NULL DEFAULT 0 COMMENT '1 for success, 0 for failure',
    message TEXT NULL COMMENT 'Response message from API',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_created_at (created_at),
    INDEX idx_admin_name (admin_name),
    INDEX idx_success (success)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;