-- Add preset-driven fields to products table
-- Run this SQL script to add the new preset fields

USE perfume_store;

-- Add new preset fields to products table
ALTER TABLE products 
ADD COLUMN scent VARCHAR(100) AFTER volume,
ADD COLUMN notes VARCHAR(100) AFTER scent,
ADD COLUMN season VARCHAR(100) AFTER notes,
ADD COLUMN recommendation VARCHAR(100) AFTER season;

-- Update existing products with sample preset values (optional)
UPDATE products SET 
    scent = 'Amber Vanilla',
    notes = 'Boozy',
    season = 'Cold Season',
    recommendation = 'Outing'
WHERE id = 1;

UPDATE products SET 
    scent = 'Floral',
    notes = 'Sweet vanilla',
    season = 'All Season',
    recommendation = 'Daily Wear'
WHERE id = 2;

-- Add indexes for the new fields
CREATE INDEX IF NOT EXISTS idx_products_scent ON products(scent);
CREATE INDEX IF NOT EXISTS idx_products_notes ON products(notes);
CREATE INDEX IF NOT EXISTS idx_products_season ON products(season);
CREATE INDEX IF NOT EXISTS idx_products_recommendation ON products(recommendation);