-- Fix cart table unique constraints to include version field
-- This allows the same product with different versions to be added to cart

-- Drop existing unique constraints
ALTER TABLE cart DROP INDEX unique_cart_item;
ALTER TABLE cart DROP INDEX unique_session_cart_item;

-- Add new unique constraints that include version
ALTER TABLE cart ADD UNIQUE KEY unique_cart_item (user_id, product_id, size, version);
ALTER TABLE cart ADD UNIQUE KEY unique_session_cart_item (session_id, product_id, size, version);