-- Fix order_items table to include proper price fields
-- Check if columns exist and add them if missing

-- Add product_price column if it doesn't exist
SET @sql = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = DATABASE() 
     AND TABLE_NAME = 'order_items' 
     AND COLUMN_NAME = 'product_price') = 0,
    'ALTER TABLE order_items ADD COLUMN product_price DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER product_name',
    'SELECT "product_price column already exists"'
));
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add total_price column if it doesn't exist
SET @sql = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = DATABASE() 
     AND TABLE_NAME = 'order_items' 
     AND COLUMN_NAME = 'total_price') = 0,
    'ALTER TABLE order_items ADD COLUMN total_price DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER quantity',
    'SELECT "total_price column already exists"'
));
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add version column if it doesn't exist
SET @sql = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = DATABASE() 
     AND TABLE_NAME = 'order_items' 
     AND COLUMN_NAME = 'version') = 0,
    'ALTER TABLE order_items ADD COLUMN version VARCHAR(20) DEFAULT NULL AFTER size',
    'SELECT "version column already exists"'
));
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;