-- Fix sale date fields to prevent Xdebug errors
-- Run this SQL script to ensure proper date field setup

USE perfume_store;

-- Update any invalid sale dates to NULL
UPDATE products 
SET sale_start_date = NULL 
WHERE sale_start_date = '0000-00-00 00:00:00' 
   OR sale_start_date = '' 
   OR sale_start_date IS NULL;

UPDATE products 
SET sale_end_date = NULL 
WHERE sale_end_date = '0000-00-00 00:00:00' 
   OR sale_end_date = '' 
   OR sale_end_date IS NULL;

-- Ensure flash_sale_started_at is properly set
UPDATE products 
SET flash_sale_started_at = NULL 
WHERE flash_sale_started_at = '0000-00-00 00:00:00' 
   OR flash_sale_started_at = '';

-- Set default values for flash sale duration if not set
UPDATE products 
SET flash_sale_duration_hours = 24 
WHERE flash_sale_duration_hours IS NULL 
   OR flash_sale_duration_hours = 0;