-- Sample Reviews Data for Testing
-- Run this script to add sample review data to test the feedback management system

USE perfume_store;

-- Insert sample reviews (ignore if already exist)
INSERT IGNORE INTO reviews (user_id, product_id, rating, title, comment, is_verified, created_at) VALUES
-- Reviews for Angel Spirit (Product ID 1)
(1, 1, 5, 'Amazing fragrance!', 'Absolutely love this perfume! The scent is amazing and lasts all day. Perfect for special occasions. Highly recommend!', 1, '2024-01-15 10:30:00'),
(1, 1, 4, 'Great quality', 'Great quality perfume with a unique fragrance. The packaging was excellent and delivery was fast. Will definitely order again!', 1, '2024-01-20 14:15:00'),
(1, 1, 5, 'Perfect scent', 'The scent is exactly as described. Very satisfied with my purchase. The customer service was also very helpful when I had questions.', 0, '2024-01-25 09:45:00'),

-- Reviews for Suave (Product ID 2)
(1, 2, 4, 'Good value', 'Excellent perfume! The fragrance is long-lasting and not too overpowering. Perfect for daily use. Great value for money!', 1, '2024-01-18 16:20:00'),
(1, 2, 3, 'Average quality', 'Good perfume overall, but the scent fades a bit faster than expected. Still worth the price though. Delivery was quick.', 0, '2024-01-22 11:30:00'),

-- Reviews for BVLGARI Rose Goldea (Product ID 3)
(1, 3, 5, 'Luxurious scent', 'This is a truly luxurious fragrance. The rose notes are beautiful and sophisticated. Perfect for evening wear.', 1, '2024-01-12 13:45:00'),
(1, 3, 4, 'Beautiful packaging', 'Love the elegant packaging and the scent is very feminine. A bit pricey but worth it for special occasions.', 1, '2024-01-28 15:10:00'),

-- Reviews for Chopard Happy Bigaradia (Product ID 4)
(1, 4, 5, 'Stunning fragrance', 'This perfume is absolutely stunning! The citrus notes are refreshing and the longevity is impressive. Highly recommended!', 1, '2024-01-14 12:00:00'),
(1, 4, 4, 'Fresh and elegant', 'A beautiful fresh scent that is perfect for daytime wear. The bottle is also very elegant. Great purchase!', 0, '2024-01-30 10:15:00'),

-- Reviews for Lancome Idol Idole Nectar (Product ID 5)
(1, 5, 4, 'Modern and chic', 'A modern fragrance that embodies confidence and femininity. The scent is sophisticated and alluring. Love it!', 1, '2024-01-16 14:30:00'),
(1, 5, 3, 'Nice but not exceptional', 'It\'s a nice perfume but nothing extraordinary. The scent is pleasant but doesn\'t last as long as I expected.', 0, '2024-01-26 17:45:00'),

-- Reviews for Christian Dior Happy Hour (Product ID 6)
(1, 6, 5, 'Joyful fragrance', 'This fragrance truly captures the joy of life! It\'s elegant, timeless, and perfect for any occasion. Love the bottle design too.', 1, '2024-01-19 11:20:00'),
(1, 6, 4, 'Classic Dior quality', 'Another classic from Dior. The quality is excellent and the scent is refined. Perfect for those who love traditional fragrances.', 1, '2024-01-24 16:50:00'),

-- Reviews for Tom Ford Black Orchid (Product ID 7)
(1, 7, 5, 'Mysterious and alluring', 'This is a truly mysterious and alluring fragrance. The deep, rich notes are perfect for evening wear. Absolutely love it!', 1, '2024-01-13 15:25:00'),
(1, 7, 4, 'Luxury at its finest', 'Tom Ford never disappoints. This is luxury at its finest. The scent is complex and sophisticated. Worth every penny.', 0, '2024-01-29 12:40:00'),

-- Reviews for Chanel No. 5 (Product ID 8)
(1, 8, 5, 'Iconic and timeless', 'The iconic Chanel No. 5 lives up to its reputation. Timeless, elegant, and absolutely beautiful. A must-have for any perfume collection.', 1, '2024-01-17 09:15:00'),
(1, 8, 4, 'Classic elegance', 'This is the definition of classic elegance. The scent is sophisticated and the longevity is impressive. A true classic.', 1, '2024-01-23 13:55:00'),

-- Reviews for Dior Sauvage (Product ID 9)
(1, 9, 5, 'Perfect for men', 'A fresh and woody fragrance that is perfect for the modern man. The scent is masculine and sophisticated. Highly recommended!', 1, '2024-01-21 10:40:00'),
(1, 9, 4, 'Great daily wear', 'Perfect for daily wear. The scent is fresh and not too overpowering. Great value for money and excellent quality.', 0, '2024-01-27 14:20:00'),

-- Reviews for Versace Eros (Product ID 10)
(1, 10, 4, 'Bold and confident', 'A bold and seductive fragrance for confident men. The scent is strong and long-lasting. Perfect for special occasions.', 1, '2024-01-11 16:35:00'),
(1, 10, 3, 'Too strong for me', 'The scent is quite strong and might be too much for some people. Good quality but not my personal preference.', 0, '2024-01-31 11:50:00');

-- Update product ratings and review counts
UPDATE products SET 
    rating = (SELECT AVG(rating) FROM reviews WHERE product_id = products.id),
    review_count = (SELECT COUNT(*) FROM reviews WHERE product_id = products.id)
WHERE id IN (SELECT DISTINCT product_id FROM reviews);