-- Voucher Management System Database Schema

-- Royal Tiers Table
CREATE TABLE IF NOT EXISTS royal_tiers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tier_name VARCHAR(50) NOT NULL,
    tier_level INT NOT NULL UNIQUE,
    min_points INT NOT NULL,
    max_points INT,
    tier_color VARCHAR(7) DEFAULT '#D4AF37',
    tier_icon VARCHAR(50) DEFAULT 'fas fa-crown',
    benefits TEXT,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Vouchers Table
CREATE TABLE IF NOT EXISTS vouchers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    voucher_name VARCHAR(100) NOT NULL,
    voucher_description TEXT,
    voucher_image VARCHAR(255),
    points_required INT NOT NULL,
    discount_type ENUM('percentage', 'fixed_amount', 'free_shipping', 'free_product') NOT NULL,
    discount_value DECIMAL(10,2),
    max_redemptions INT DEFAULT NULL,
    current_redemptions INT DEFAULT 0,
    valid_from DATE NOT NULL,
    valid_until DATE NOT NULL,
    is_active BOOLEAN DEFAULT TRUE,
    created_by INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_points_required (points_required),
    INDEX idx_valid_dates (valid_from, valid_until),
    INDEX idx_active (is_active)
);

-- User Voucher Redemptions Table
CREATE TABLE IF NOT EXISTS user_voucher_redemptions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    voucher_id INT NOT NULL,
    redeemed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    order_id INT DEFAULT NULL,
    points_used INT NOT NULL,
    status ENUM('active', 'used', 'expired') DEFAULT 'active',
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (voucher_id) REFERENCES vouchers(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id),
    INDEX idx_voucher_id (voucher_id),
    INDEX idx_status (status)
);

-- Insert default royal tiers
INSERT INTO royal_tiers (tier_name, tier_level, min_points, max_points, tier_color, tier_icon, benefits) VALUES
('Bronze', 1, 0, 999, '#CD7F32', 'fas fa-medal', 'Basic rewards and standard shipping'),
('Silver', 2, 1000, 4999, '#C0C0C0', 'fas fa-medal', 'Priority support and faster shipping'),
('Gold', 3, 5000, 9999, '#FFD700', 'fas fa-crown', 'Exclusive products and free shipping'),
('Platinum', 4, 10000, 19999, '#E5E4E2', 'fas fa-gem', 'VIP treatment and early access'),
('Diamond', 5, 20000, NULL, '#B9F2FF', 'fas fa-diamond', 'Ultimate luxury experience and personal concierge');

-- Insert sample vouchers
INSERT INTO vouchers (voucher_name, voucher_description, points_required, discount_type, discount_value, max_redemptions, valid_from, valid_until) VALUES
('Welcome Bonus', 'Get 10% off your first purchase', 100, 'percentage', 10.00, 1000, CURDATE(), DATE_ADD(CURDATE(), INTERVAL 1 YEAR)),
('Free Shipping', 'Enjoy free shipping on your order', 500, 'free_shipping', 0.00, 500, CURDATE(), DATE_ADD(CURDATE(), INTERVAL 6 MONTH)),
('RM 20 Off', 'Get RM 20 off your purchase', 1000, 'fixed_amount', 20.00, 200, CURDATE(), DATE_ADD(CURDATE(), INTERVAL 3 MONTH)),
('Premium Sample', 'Free premium perfume sample', 2000, 'free_product', 0.00, 100, CURDATE(), DATE_ADD(CURDATE(), INTERVAL 1 YEAR));