<?php
/**
 * Appilix User Identity Script
 * Sets the user identity for Appilix push notifications
 * Include this file in the header of pages where users are logged in
 */

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Only set user identity if user is logged in and not a guest
if (isset($_SESSION['user_id']) && !empty($_SESSION['user_id'])) {
    $isGuest = isset($_SESSION['is_guest']) && $_SESSION['is_guest'] === true;
    
    if (!$isGuest) {
        // Use user ID as the identity (you can also use email if preferred)
        $userIdentity = $_SESSION['user_id'];
        
        // You can also use email or a combination
        // $userIdentity = $_SESSION['user_email'] ?? $_SESSION['user_id'];
        
        echo "\n<!-- Appilix Push Notification User Identity -->\n";
        echo "<script>\n";
        echo "// Set Appilix user identity for targeted push notifications\n";
        echo "var appilix_push_notification_user_identity = '" . htmlspecialchars($userIdentity, ENT_QUOTES, 'UTF-8') . "';\n";
        echo "console.log('Appilix user identity set:', appilix_push_notification_user_identity);\n";
        echo "</script>\n";
        echo "<!-- End Appilix User Identity -->\n\n";
        
        // Also set a cookie as a backup method
        if (!isset($_COOKIE['appilix_push_notification_user_identity']) || $_COOKIE['appilix_push_notification_user_identity'] !== $userIdentity) {
            setcookie('appilix_push_notification_user_identity', $userIdentity, [
                'expires' => time() + (86400 * 30), // 30 days
                'path' => '/',
                'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
                'httponly' => false, // Must be false so JavaScript can read it
                'samesite' => 'Lax'
            ]);
        }
    }
}
?>

