<?php
require_once 'models/Loyalty.php';

class LoyaltyIntegration {
    private $loyalty;

    public function __construct() {
        $this->loyalty = new Loyalty();
    }

    /**
     * Award points for purchase
     */
    public function awardPurchasePoints($userId, $orderId, $totalAmount) {
        // Calculate points (1 point per RM1 spent)
        $points = floor($totalAmount);
        
        if ($points > 0) {
            $description = "Purchase - Order #" . $orderId;
            return $this->loyalty->addPoints($userId, $points, 'earned', $description, $orderId, 'ORDER' . $orderId);
        }
        
        return false;
    }

    /**
     * Award stamp for purchase
     */
    public function awardPurchaseStamp($userId) {
        return $this->loyalty->addStamp($userId);
    }

    /**
     * Process referral code usage
     */
    public function processReferralCode($referralCode, $newUserId) {
        return $this->loyalty->useReferralCode($referralCode, $newUserId);
    }

    /**
     * Get user's current tier benefits
     */
    public function getUserTierBenefits($userId) {
        $loyaltyData = $this->loyalty->getUserLoyaltyData($userId);
        
        if (!$loyaltyData) {
            return null;
        }

        $tier = $loyaltyData['tier'];
        $benefits = [];

        switch ($tier) {
            case 'bronze':
                $benefits = [
                    'points_multiplier' => 1.0,
                    'free_shipping_threshold' => null,
                    'priority_support' => false,
                    'exclusive_access' => false
                ];
                break;
            case 'silver':
                $benefits = [
                    'points_multiplier' => 1.5,
                    'free_shipping_threshold' => 100.00,
                    'priority_support' => true,
                    'exclusive_access' => true
                ];
                break;
            case 'gold':
                $benefits = [
                    'points_multiplier' => 2.0,
                    'free_shipping_threshold' => 0.00,
                    'priority_support' => true,
                    'exclusive_access' => true
                ];
                break;
        }

        return $benefits;
    }
}
?>