<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Privacy Policy - Perfume UI</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            line-height: 1.6;
            color: #333;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            padding: 0;
        }

        .mobile-container {
            max-width: 100%;
            margin: 0;
            background: white;
            min-height: 100vh;
            position: relative;
        }

        .header {
            background: linear-gradient(135deg, #1A4D2A 0%, #2d5a3d 100%);
            color: white;
            padding: 20px;
            text-align: center;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .header h1 {
            font-size: 1.8rem;
            margin-bottom: 5px;
            font-weight: 700;
        }

        .header .subtitle {
            font-size: 0.9rem;
            opacity: 0.9;
        }

        .content {
            padding: 20px;
            padding-bottom: 80px;
        }

        .effective-date {
            background: linear-gradient(135deg, #e8f5e8 0%, #d4edda 100%);
            padding: 15px;
            border-radius: 12px;
            margin-bottom: 25px;
            text-align: center;
            border-left: 4px solid #1A4D2A;
        }

        .effective-date strong {
            color: #1A4D2A;
            font-size: 1rem;
        }

        .intro {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 25px;
            border-left: 4px solid #1A4D2A;
        }

        .intro p {
            font-size: 1rem;
            line-height: 1.7;
            color: #555;
        }

        .section {
            margin-bottom: 30px;
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            border: 1px solid #e9ecef;
        }

        .section h2 {
            color: #1A4D2A;
            font-size: 1.3rem;
            margin-bottom: 15px;
            padding-bottom: 8px;
            border-bottom: 2px solid #e8f5e8;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .section h3 {
            color: #2d5a3d;
            font-size: 1.1rem;
            margin: 15px 0 10px 0;
            font-weight: 600;
        }

        .section p {
            margin-bottom: 12px;
            font-size: 0.95rem;
            line-height: 1.6;
        }

        .section ul {
            margin-left: 15px;
            margin-bottom: 12px;
        }

        .section li {
            margin-bottom: 6px;
            line-height: 1.5;
            font-size: 0.95rem;
        }

        .highlight {
            background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #ffc107;
            margin: 15px 0;
        }

        .highlight p {
            margin: 0;
            font-weight: 500;
            font-size: 0.9rem;
        }

        .contact-info {
            background: linear-gradient(135deg, #e8f5e8 0%, #d4edda 100%);
            padding: 20px;
            border-radius: 12px;
            margin-top: 25px;
        }

        .contact-info h3 {
            color: #1A4D2A;
            margin-bottom: 15px;
            font-size: 1.2rem;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .contact-item {
            display: flex;
            align-items: flex-start;
            gap: 12px;
            margin-bottom: 15px;
            padding: 10px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .contact-item i {
            color: #1A4D2A;
            font-size: 1.1rem;
            width: 20px;
            margin-top: 2px;
        }

        .contact-item div {
            flex: 1;
        }

        .contact-item strong {
            color: #1A4D2A;
            font-size: 0.9rem;
        }

        .back-button {
            position: fixed;
            bottom: 20px;
            left: 20px;
            right: 20px;
            background: linear-gradient(135deg, #1A4D2A 0%, #2d5a3d 100%);
            color: white;
            padding: 15px 20px;
            border: none;
            border-radius: 25px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            box-shadow: 0 4px 15px rgba(26, 77, 42, 0.3);
            transition: all 0.3s ease;
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .back-button:hover {
            background: linear-gradient(135deg, #0f3d1f 0%, #1A4D2A 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(26, 77, 42, 0.4);
        }

        .back-button:active {
            transform: translateY(0);
        }

        .last-updated {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e8f5e8;
            color: #666;
            font-size: 0.85rem;
        }

        .section-number {
            background: #1A4D2A;
            color: white;
            width: 24px;
            height: 24px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.8rem;
            font-weight: bold;
            flex-shrink: 0;
        }

        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }

        /* Custom scrollbar for webkit browsers */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        ::-webkit-scrollbar-thumb {
            background: #1A4D2A;
            border-radius: 3px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #0f3d1f;
        }

        /* Loading animation */
        .loading {
            opacity: 0;
            transform: translateY(20px);
            transition: opacity 0.6s ease, transform 0.6s ease;
        }

        .loading.loaded {
            opacity: 1;
            transform: translateY(0);
        }

        /* Responsive adjustments */
        @media (max-width: 480px) {
            .content {
                padding: 15px;
            }
            
            .section {
                padding: 15px;
            }
            
            .header h1 {
                font-size: 1.6rem;
            }
            
            .back-button {
                bottom: 15px;
                left: 15px;
                right: 15px;
                padding: 12px 15px;
                font-size: 0.9rem;
            }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="mobile-container">
        <div class="header">
            <h1><i class="fas fa-shield-alt"></i> Privacy Policy</h1>
            <p class="subtitle">Perfume UI Mobile App</p>
        </div>

        <div class="content">
            <div class="effective-date">
                <strong>Effective Date: October 7, 2025</strong>
            </div>

            <div class="intro loading">
                <p>
                    Welcome to 2 Days Parfum. We are committed to protecting your privacy and ensuring the security of your personal information. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you use our mobile application.
                </p>
            </div>

            <div class="section loading">
                <h2><span class="section-number">1</span> Information We Collect</h2>
                
                <h3>Personal Information</h3>
                <p>When you create an account or use our App, we may collect:</p>
                <ul>
                    <li><strong>Account Information:</strong> Name, email address, phone number, and password</li>
                    <li><strong>Profile Information:</strong> Profile picture, preferences, and settings</li>
                    <li><strong>Contact Information:</strong> Shipping address, billing address, and contact details</li>
                </ul>

                <h3>Usage Information</h3>
                <p>We automatically collect certain information when you use our App:</p>
                <ul>
                    <li><strong>Device Information:</strong> Device type, operating system, unique device identifiers</li>
                    <li><strong>Usage Data:</strong> App features used, time spent in the App, pages viewed</li>
                    <li><strong>Location Data:</strong> General location information (with your consent)</li>
                    <li><strong>Log Data:</strong> IP address, browser type, access times, and referring URLs</li>
                </ul>

                <h3>Transaction Information</h3>
                <p>When you make purchases through our App, we collect:</p>
                <ul>
                    <li><strong>Payment Information:</strong> Payment method details (processed securely through third-party providers)</li>
                    <li><strong>Order Information:</strong> Purchase history, order details, and transaction records</li>
                    <li><strong>Shipping Information:</strong> Delivery addresses and tracking information</li>
                </ul>
            </div>

            <div class="section loading">
                <h2><span class="section-number">2</span> How We Use Your Information</h2>
                <p>We use the collected information for the following purposes:</p>
                <ul>
                    <li><strong>Service Provision:</strong> To provide, maintain, and improve our App and services</li>
                    <li><strong>Account Management:</strong> To create and manage your account, process transactions, and provide customer support</li>
                    <li><strong>Personalization:</strong> To personalize your experience and recommend products you might like</li>
                    <li><strong>Communication:</strong> To send you updates, notifications, and promotional materials (with your consent)</li>
                    <li><strong>Analytics:</strong> To analyze App usage and improve our services</li>
                    <li><strong>Legal Compliance:</strong> To comply with legal obligations and protect our rights</li>
                    <li><strong>Security:</strong> To detect, prevent, and address fraud, security issues, and technical problems</li>
                </ul>
            </div>

            <div class="section loading">
                <h2><span class="section-number">3</span> Information Sharing and Disclosure</h2>
                <p>We do not sell, trade, or rent your personal information to third parties. We may share your information in the following circumstances:</p>
                <ul>
                    <li><strong>Service Providers:</strong> With trusted third-party service providers who assist us in operating our App</li>
                    <li><strong>Legal Requirements:</strong> When required by law or to protect our rights and safety</li>
                    <li><strong>Business Transfers:</strong> In connection with a merger, acquisition, or sale of assets</li>
                    <li><strong>Consent:</strong> When you have given us explicit consent to share your information</li>
                </ul>
            </div>

            <div class="section loading">
                <h2><span class="section-number">4</span> Data Security</h2>
                <p>We implement appropriate security measures to protect your personal information:</p>
                <ul>
                    <li><strong>Encryption:</strong> Data is encrypted during transmission and storage</li>
                    <li><strong>Access Controls:</strong> Limited access to personal information on a need-to-know basis</li>
                    <li><strong>Regular Audits:</strong> Regular security assessments and updates</li>
                    <li><strong>Secure Servers:</strong> Information stored on secure, protected servers</li>
                </ul>
                <div class="highlight">
                    <p><strong>Note:</strong> While we strive to protect your information, no method of transmission over the internet is 100% secure. We cannot guarantee absolute security.</p>
                </div>
            </div>

            <div class="section loading">
                <h2><span class="section-number">5</span> Your Rights and Choices</h2>
                <p>You have the following rights regarding your personal information:</p>
                <ul>
                    <li><strong>Access:</strong> Request access to your personal information</li>
                    <li><strong>Correction:</strong> Update or correct your personal information</li>
                    <li><strong>Deletion:</strong> Request deletion of your personal information</li>
                    <li><strong>Portability:</strong> Request a copy of your data in a portable format</li>
                    <li><strong>Opt-out:</strong> Unsubscribe from marketing communications</li>
                    <li><strong>Account Deletion:</strong> Delete your account and associated data</li>
                </ul>
                <p>You can exercise these rights by contacting us using the information provided in the "Contact Us" section below.</p>
            </div>

            <div class="section loading">
                <h2><span class="section-number">6</span> Data Retention</h2>
                <p>We retain your personal information for as long as necessary to:</p>
                <ul>
                    <li>Provide our services and maintain your account</li>
                    <li>Comply with legal obligations</li>
                    <li>Resolve disputes and enforce our agreements</li>
                    <li>Improve our services and develop new features</li>
                </ul>
                <p>When we no longer need your information, we will securely delete or anonymize it.</p>
            </div>

            <div class="section loading">
                <h2><span class="section-number">7</span> Children's Privacy</h2>
                <p>Our App is not intended for children under 13 years of age. We do not knowingly collect personal information from children under 13. If you are a parent or guardian and believe your child has provided us with personal information, please contact us immediately.</p>
            </div>

            <div class="section loading">
                <h2><span class="section-number">8</span> International Data Transfers</h2>
                <p>Your information may be transferred to and processed in countries other than your own. We ensure that such transfers comply with applicable data protection laws and implement appropriate safeguards to protect your information.</p>
            </div>

            <div class="section loading">
                <h2><span class="section-number">9</span> Changes to This Privacy Policy</h2>
                <p>We may update this Privacy Policy from time to time. We will notify you of any changes by:</p>
                <ul>
                    <li>Posting the new Privacy Policy in the App</li>
                    <li>Sending you an email notification</li>
                    <li>Displaying a prominent notice in the App</li>
                </ul>
                <p>Your continued use of the App after any changes indicates your acceptance of the updated Privacy Policy.</p>
            </div>

            <div class="contact-info loading">
                <h3><i class="fas fa-envelope"></i> Contact Us</h3>
                <p>If you have any questions about this Privacy Policy or our privacy practices, please contact us:</p>
                
                <div class="contact-item">
                    <i class="fas fa-envelope"></i>
                    <div>
                        <strong>Email</strong><br>
                        perfume2days@gmail.com
                    </div>
                </div>
                
                <div class="contact-item">
                    <i class="fas fa-phone"></i>
                    <div>
                        <strong>Phone</strong><br>
                        0172053153
                    </div>
                </div>
                
                <div class="contact-item">
                    <i class="fas fa-map-marker-alt"></i>
                    <div>
                        <strong>Address</strong><br>
                        Pt 509, Jalan Kuala Krai,<br>
                        pusat perniagaan bandar baharu tunjung, 16010 Kota Bharu, Kelantan
                </div>
                
                <div class="contact-item">
                    <i class="fas fa-clock"></i>
                    <div>
                        <strong>Response Time</strong><br>
                        Within 24-48 hours
                    </div>
                </div>
            </div>

            <div class="last-updated loading">
                <p><i class="fas fa-calendar-alt"></i> october 7, 2025</p>
            </div>
        </div>

        <button class="back-button" onclick="goBack()">
            <i class="fas fa-arrow-left"></i>
            Back
        </button>
    </div>

    <script>
        function goBack() {
            // Close the current window/tab
            window.close();
            
            // If window.close() doesn't work (some browsers block it), use history.back()
            setTimeout(function() {
                if (!window.closed) {
                    window.history.back();
                }
            }, 100);
        }

        // Add loading animation
        document.addEventListener('DOMContentLoaded', function() {
            const loadingElements = document.querySelectorAll('.loading');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('loaded');
                    }
                });
            }, {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            });

            loadingElements.forEach(element => {
                observer.observe(element);
            });

            // Add touch feedback for mobile
            const backButton = document.querySelector('.back-button');
            backButton.addEventListener('touchstart', function() {
                this.style.transform = 'translateY(0) scale(0.98)';
            });
            
            backButton.addEventListener('touchend', function() {
                this.style.transform = 'translateY(-2px) scale(1)';
            });
        });

        // Prevent zoom on double tap for mobile
        let lastTouchEnd = 0;
        document.addEventListener('touchend', function (event) {
            const now = (new Date()).getTime();
            if (now - lastTouchEnd <= 300) {
                event.preventDefault();
            }
            lastTouchEnd = now;
        }, false);
    </script>
</body>
</html>
