<?php
/**
 * toyyibPay Payment Return Handler
 * This file handles the return from toyyibPay after payment
 */

session_start();
require_once 'config/database.php';
require_once 'models/Order.php';
require_once 'models/ToyyibPay.php';

// Get return parameters
$status_id = $_GET['status_id'] ?? $_GET['status'] ?? '';
$billcode = $_GET['billcode'] ?? $_GET['bill_code'] ?? '';
$order_id = $_GET['order_id'] ?? $_GET['orderid'] ?? '';

// Log return data for debugging
error_log("toyyibPay Return: " . print_r($_GET, true));
error_log("toyyibPay Return - status_id: $status_id, billcode: $billcode, order_id: $order_id");

// Redirect to appropriate page based on payment status
if (!empty($order_id)) {
    try {
        $order = new Order();
        $order_data = $order->getById($order_id);
        
        if ($order_data) {
            // If status_id is empty, try to determine from billcode
            if (empty($status_id) && !empty($billcode)) {
                // Try to get status from ToyyibPay API
                $toyyibpay = new ToyyibPay();
                $bill_status = $toyyibpay->getBillTransactions($billcode);
                
                if ($bill_status && isset($bill_status[0]['billpaymentStatus'])) {
                    $status_id = $bill_status[0]['billpaymentStatus'];
                    error_log("toyyibPay Return: Got status from API - $status_id");
                }
            }
            
            // Redirect to order success page
            $redirect_url = 'order-success.php?id=' . $order_id;
            if (!empty($status_id)) {
                $redirect_url .= '&payment_status=' . $status_id;
            }
            
            error_log("toyyibPay Return: Redirecting to $redirect_url");
            header('Location: ' . $redirect_url);
            exit;
        }
    } catch (Exception $e) {
        error_log("Error in payment return: " . $e->getMessage());
    }
}

// Fallback redirect
$fallback_url = 'order-success.php';
if (!empty($status_id)) {
    $fallback_url .= '?payment_status=' . $status_id;
}
error_log("toyyibPay Return: Fallback redirect to $fallback_url");
header('Location: ' . $fallback_url);
exit;
?>