<?php
/**
 * Quick ToyyibPay Sandbox Test
 * Simple test to check basic connectivity
 */

require_once 'config/payment.php';
require_once 'models/ToyyibPay.php';

echo "<h1>⚡ Quick ToyyibPay Test</h1>";

echo "<h2>📋 Current Settings:</h2>";
echo "<ul>";
echo "<li><strong>API:</strong> " . TOYYIBPAY_API_URL . "</li>";
echo "<li><strong>Key:</strong> " . substr(TOYYIBPAY_USER_SECRET_KEY, 0, 8) . "...</li>";
echo "<li><strong>Category:</strong> " . TOYYIBPAY_CATEGORY_CODE . "</li>";
echo "</ul>";

echo "<h2>🧪 Quick Tests:</h2>";

try {
    $toyyibpay = new ToyyibPay();
    
    // Test 1: Basic connectivity
    echo "<h3>1. Basic API Test:</h3>";
    $result = $toyyibpay->testApiConnection();
    
    if ($result !== false) {
        echo "✅ <strong>API is reachable!</strong><br>";
        echo "Response: <pre>" . print_r($result, true) . "</pre>";
    } else {
        echo "❌ <strong>Cannot reach API</strong><br>";
        echo "Check your PHP error logs for details.<br>";
    }
    
    // Test 2: Category test
    echo "<h3>2. Category Test:</h3>";
    $cat_result = $toyyibpay->testCategoryAccess();
    
    if ($cat_result !== false) {
        echo "✅ <strong>Category is accessible!</strong><br>";
        echo "Response: <pre>" . print_r($cat_result, true) . "</pre>";
    } else {
        echo "❌ <strong>Category not accessible</strong><br>";
        echo "The category code might not exist in sandbox.<br>";
    }
    
    // Test 3: Try creating a simple bill
    echo "<h3>3. Bill Creation Test:</h3>";
    $bill_data = [
        'bill_name' => 'Quick Test',
        'bill_description' => 'Quick test bill',
        'amount' => 1.00,
        'order_id' => 'QUICK_TEST_' . time(),
        'customer_name' => 'Test User',
        'customer_email' => 'test@example.com',
        'customer_phone' => '0123456789',
        'payment_method' => 'toyyibpay_fpx'
    ];
    
    $bill_result = $toyyibpay->createBill($bill_data);
    
    if ($bill_result && !isset($bill_result['error'])) {
        echo "✅ <strong>Bill creation works!</strong><br>";
        echo "Bill Code: <code>" . $bill_result['bill_code'] . "</code><br>";
        echo "Payment URL: <a href='" . $bill_result['payment_url'] . "' target='_blank'>Open Payment</a><br>";
    } else {
        echo "❌ <strong>Bill creation failed</strong><br>";
        if (isset($bill_result['error'])) {
            echo "Error: " . $bill_result['message'] . "<br>";
        }
    }
    
} catch (Exception $e) {
    echo "❌ <strong>Exception:</strong> " . $e->getMessage() . "<br>";
}

echo "<h2>📝 Next Steps:</h2>";
echo "<ol>";
echo "<li>Check your PHP error logs for detailed messages</li>";
echo "<li>If category test fails, create a new category in sandbox dashboard</li>";
echo "<li>If API test fails, check your network/firewall settings</li>";
echo "</ol>";

echo "<hr>";
echo "<p><a href='debug-sandbox.php'>Detailed Debug</a> | <a href='checkout.php'>Try Checkout</a></p>";
?>