<?php
require_once 'config/database.php';

echo "Setting up Google OAuth database columns...\n";

try {
    $db = getDB();
    
    // Check if columns exist
    $stmt = $db->query("DESCRIBE users");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    $changes_made = false;
    
    // Add google_id column if it doesn't exist
    if (!in_array('google_id', $columns)) {
        echo "Adding google_id column...\n";
        $db->exec("ALTER TABLE users ADD COLUMN google_id VARCHAR(191) UNIQUE NULL AFTER email");
        $changes_made = true;
    } else {
        echo "✓ google_id column already exists\n";
    }
    
    // Add email_verified column if it doesn't exist
    if (!in_array('email_verified', $columns)) {
        echo "Adding email_verified column...\n";
        $db->exec("ALTER TABLE users ADD COLUMN email_verified BOOLEAN DEFAULT FALSE AFTER password");
        $changes_made = true;
    } else {
        echo "✓ email_verified column already exists\n";
    }
    
    // Make password nullable for OAuth users
    echo "Making password column nullable...\n";
    $db->exec("ALTER TABLE users MODIFY COLUMN password VARCHAR(255) NULL");
    
    // Create index for Google ID if it doesn't exist
    try {
        $db->exec("CREATE INDEX idx_users_google_id ON users(google_id)");
        echo "✓ Created index for google_id\n";
    } catch (Exception $e) {
        if (strpos($e->getMessage(), 'Duplicate key name') !== false) {
            echo "✓ Index for google_id already exists\n";
        } else {
            echo "Warning: Could not create index: " . $e->getMessage() . "\n";
        }
    }
    
    // Update existing users to have email_verified = TRUE
    $stmt = $db->exec("UPDATE users SET email_verified = TRUE WHERE google_id IS NULL AND password IS NOT NULL");
    echo "✓ Updated $stmt existing users to verified status\n";
    
    if ($changes_made) {
        echo "\n✓ Database setup completed successfully!\n";
    } else {
        echo "\n✓ Database already properly configured!\n";
    }
    
} catch (Exception $e) {
    echo "✗ Error setting up database: " . $e->getMessage() . "\n";
}
?>