<?php
/**
 * Email Configuration Test Script
 * Use this to test if your email settings are working correctly
 */

require_once 'config/email.php';

$testEmail = '';
$result = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $testEmail = trim($_POST['test_email'] ?? '');
    
    if (!empty($testEmail) && filter_var($testEmail, FILTER_VALIDATE_EMAIL)) {
        $subject = 'Test Email from 2 Days Parfume';
        $body = '
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: #3498db; color: white; padding: 20px; text-align: center; border-radius: 5px; }
                .content { background: #f9f9f9; padding: 20px; margin: 20px 0; border-radius: 5px; }
                .footer { text-align: center; color: #666; font-size: 12px; }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="header">
                    <h1>✅ Email Test Successful!</h1>
                </div>
                <div class="content">
                    <p>Congratulations! Your email configuration is working correctly.</p>
                    <p><strong>Test Details:</strong></p>
                    <ul>
                        <li>SMTP Host: ' . SMTP_HOST . '</li>
                        <li>SMTP Port: ' . SMTP_PORT . '</li>
                        <li>From: ' . SMTP_FROM_EMAIL . '</li>
                        <li>Sent at: ' . date('Y-m-d H:i:s') . '</li>
                    </ul>
                    <p>You can now use the forgot password functionality!</p>
                </div>
                <div class="footer">
                    <p>This is a test email from 2 Days Parfume</p>
                </div>
            </div>
        </body>
        </html>
        ';
        
        $result = sendEmail($testEmail, $subject, $body);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Configuration Test</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 600px;
            width: 100%;
            padding: 40px;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
        }
        .subtitle {
            color: #666;
            margin-bottom: 30px;
            font-size: 14px;
        }
        .config-info {
            background: #f5f5f5;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
        }
        .config-info h3 {
            color: #333;
            margin-bottom: 15px;
            font-size: 16px;
        }
        .config-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #e0e0e0;
        }
        .config-item:last-child {
            border-bottom: none;
        }
        .config-label {
            font-weight: bold;
            color: #555;
        }
        .config-value {
            color: #3498db;
            font-family: 'Courier New', monospace;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: bold;
        }
        input[type="email"] {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        input[type="email"]:focus {
            outline: none;
            border-color: #3498db;
        }
        .btn {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.2s;
        }
        .btn:hover {
            transform: translateY(-2px);
        }
        .btn:active {
            transform: translateY(0);
        }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .alert-success {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }
        .alert-error {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }
        .alert-warning {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            color: #856404;
        }
        .icon {
            font-size: 20px;
        }
        .back-link {
            text-align: center;
            margin-top: 20px;
        }
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-size: 14px;
        }
        .back-link a:hover {
            text-decoration: underline;
        }
        .info-box {
            background: #e3f2fd;
            border-left: 4px solid #2196f3;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        .info-box p {
            margin: 5px 0;
            font-size: 14px;
            color: #1976d2;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>📧 Email Configuration Test</h1>
        <p class="subtitle">Test your SMTP settings before using the forgot password feature</p>

        <?php if ($result !== null): ?>
            <?php if ($result['success']): ?>
                <div class="alert alert-success">
                    <span class="icon">✅</span>
                    <div>
                        <strong>Success!</strong> Test email sent successfully to <?php echo htmlspecialchars($testEmail); ?>
                        <br><small>Check your inbox (and spam folder) for the test email.</small>
                    </div>
                </div>
            <?php else: ?>
                <div class="alert alert-error">
                    <span class="icon">❌</span>
                    <div>
                        <strong>Error!</strong> Failed to send email.
                        <br><small><?php echo htmlspecialchars($result['message']); ?></small>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <?php if (SMTP_PASSWORD === "Use the email account's password"): ?>
            <div class="alert alert-warning">
                <span class="icon">⚠️</span>
                <div>
                    <strong>Warning!</strong> SMTP password is not configured.
                    <br><small>Please update the password in <code>config/email.php</code></small>
                </div>
            </div>
        <?php endif; ?>

        <div class="config-info">
            <h3>📋 Current Email Configuration</h3>
            <div class="config-item">
                <span class="config-label">SMTP Host:</span>
                <span class="config-value"><?php echo SMTP_HOST; ?></span>
            </div>
            <div class="config-item">
                <span class="config-label">SMTP Port:</span>
                <span class="config-value"><?php echo SMTP_PORT; ?></span>
            </div>
            <div class="config-item">
                <span class="config-label">Username:</span>
                <span class="config-value"><?php echo SMTP_USERNAME; ?></span>
            </div>
            <div class="config-item">
                <span class="config-label">Encryption:</span>
                <span class="config-value"><?php echo SMTP_ENCRYPTION; ?></span>
            </div>
            <div class="config-item">
                <span class="config-label">From Email:</span>
                <span class="config-value"><?php echo SMTP_FROM_EMAIL; ?></span>
            </div>
            <div class="config-item">
                <span class="config-label">From Name:</span>
                <span class="config-value"><?php echo SMTP_FROM_NAME; ?></span>
            </div>
        </div>

        <div class="info-box">
            <p><strong>💡 How to test:</strong></p>
            <p>1. Enter your email address below</p>
            <p>2. Click "Send Test Email"</p>
            <p>3. Check your inbox for the test email</p>
            <p>4. If successful, your forgot password feature is ready!</p>
        </div>

        <form method="POST" action="">
            <div class="form-group">
                <label for="test_email">Enter Your Email Address:</label>
                <input 
                    type="email" 
                    id="test_email" 
                    name="test_email" 
                    placeholder="your.email@example.com" 
                    required
                    value="<?php echo htmlspecialchars($testEmail); ?>"
                >
            </div>

            <button type="submit" class="btn">
                📨 Send Test Email
            </button>
        </form>

        <div class="back-link">
            <a href="setup-forgot-password.php">← Back to Setup</a> | 
            <a href="login.php">Go to Login</a> | 
            <a href="forgot-password.php">Test Forgot Password</a>
        </div>
    </div>
</body>
</html>

