<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Access - Perfume Store</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #000 0%, #333 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
        }
        
        .access-container {
            text-align: center;
            background: rgba(255, 255, 255, 0.1);
            padding: 40px;
            border-radius: 15px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            max-width: 500px;
            width: 90%;
        }
        
        .logo {
            width: 100px;
            height: 100px;
            margin: 0 auto 30px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 48px;
            color: #000;
        }
        
        h1 {
            font-size: 32px;
            margin-bottom: 20px;
            font-weight: 700;
        }
        
        p {
            font-size: 18px;
            margin-bottom: 30px;
            opacity: 0.9;
        }
        
        .access-buttons {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        
        .btn {
            display: inline-block;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            transition: all 0.3s;
            border: 2px solid transparent;
        }
        
        .btn-primary {
            background: white;
            color: #000;
        }
        
        .btn-primary:hover {
            background: transparent;
            color: white;
            border-color: white;
        }
        
        .btn-secondary {
            background: transparent;
            color: white;
            border-color: white;
        }
        
        .btn-secondary:hover {
            background: white;
            color: #000;
        }
        
        .credentials {
            margin-top: 30px;
            padding: 20px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            font-size: 14px;
        }
        
        .credentials h3 {
            margin-bottom: 15px;
            color: #fff;
        }
        
        .credential-item {
            margin-bottom: 8px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .credential-item strong {
            color: #fff;
        }
        
        .credential-item span {
            background: rgba(255, 255, 255, 0.2);
            padding: 4px 8px;
            border-radius: 4px;
            font-family: monospace;
        }
        
        @media (max-width: 600px) {
            .access-container {
                padding: 30px 20px;
            }
            
            h1 {
                font-size: 24px;
            }
            
            p {
                font-size: 16px;
            }
            
            .credentials {
                font-size: 12px;
            }
        }
    </style>
</head>
<body>
    <div class="access-container">
        <div class="logo">
            <i class="fas fa-crown"></i>
        </div>
        
        <h1>Admin Panel Access</h1>
        <p>Manage your perfume store with our comprehensive admin dashboard</p>
        
        <div class="access-buttons">
            <a href="admin/" class="btn btn-primary">
                <i class="fas fa-tachometer-alt"></i>
                Access Admin Panel
            </a>
            <a href="index.php" class="btn btn-secondary">
                <i class="fas fa-store"></i>
                View Store Frontend
            </a>
        </div>
        
        <div class="credentials">
            <h3>Demo Login Credentials</h3>
            <div class="credential-item">
                <strong>Admin Account:</strong>
                <span>admin@perfume.com / admin123</span>
            </div>
            <div class="credential-item">
                <strong>Owner Account:</strong>
                <span>owner@perfume.com / owner123</span>
            </div>
        </div>
    </div>
    
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</body>
</html>