<?php
header('Content-Type: application/json');
require_once '../../config/database.php';
require_once '../includes/Preset.php';

// Simple admin authentication
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Get database connection
$pdo = getDB();
if (!$pdo) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

$presetModel = new Preset();
$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

try {
    switch ($method) {
        case 'GET':
            if (isset($_GET['field_type'])) {
                // Get presets for specific field type
                $presets = $presetModel->getPresetsByFieldType($_GET['field_type']);
                echo json_encode(['success' => true, 'data' => $presets]);
            } else {
                // Get all presets grouped
                $presets = $presetModel->getAllPresetsGrouped();
                echo json_encode(['success' => true, 'data' => $presets]);
            }
            break;
            
        case 'POST':
            // Add new preset
            if (!isset($input['field_type']) || !isset($input['field_name']) || !isset($input['preset_value'])) {
                throw new Exception('Missing required fields');
            }
            
            $result = $presetModel->addPreset(
                $input['field_type'],
                $input['field_name'],
                $input['preset_value'],
                $input['sort_order'] ?? 0
            );
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'Preset added successfully']);
            } else {
                throw new Exception('Failed to add preset');
            }
            break;
            
        case 'PUT':
            // Update preset
            if (!isset($input['id']) || !isset($input['field_type']) || !isset($input['field_name']) || !isset($input['preset_value'])) {
                throw new Exception('Missing required fields');
            }
            
            $result = $presetModel->updatePreset(
                $input['id'],
                $input['field_type'],
                $input['field_name'],
                $input['preset_value'],
                $input['sort_order'] ?? 0,
                $input['is_active'] ?? true
            );
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'Preset updated successfully']);
            } else {
                throw new Exception('Failed to update preset');
            }
            break;
            
        case 'DELETE':
            // Delete preset
            if (!isset($_GET['id'])) {
                throw new Exception('Missing preset ID');
            }
            
            $result = $presetModel->deletePreset($_GET['id']);
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'Preset deleted successfully']);
            } else {
                throw new Exception('Failed to delete preset');
            }
            break;
            
        default:
            throw new Exception('Method not allowed');
    }
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>