<?php
require_once '../includes/auth.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

$adminFunctions = new AdminFunctions();
$action = $_GET['action'] ?? '';

try {
    switch ($action) {
        case 'get':
            $id = (int)($_GET['id'] ?? 0);
            if (!$id) {
                throw new Exception('Invalid shipping fee ID');
            }
            
            $shippingFee = $adminFunctions->getShippingFeeById($id);
            if (!$shippingFee) {
                throw new Exception('Shipping fee not found');
            }
            
            echo json_encode([
                'success' => true,
                'data' => $shippingFee
            ]);
            break;
            
        case 'delete':
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                throw new Exception('Invalid request method');
            }
            
            $id = (int)($_POST['id'] ?? 0);
            
            if (!$id) {
                throw new Exception('Invalid shipping fee ID');
            }
            
            if ($adminFunctions->deleteShippingFee($id)) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Shipping fee deleted successfully!'
                ]);
            } else {
                throw new Exception('Failed to delete shipping fee');
            }
            break;
            
        case 'toggle_status':
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                throw new Exception('Invalid request method');
            }
            
            $id = (int)($_POST['id'] ?? 0);
            $isActive = (int)($_POST['is_active'] ?? 0);
            
            if (!$id) {
                throw new Exception('Invalid shipping fee ID');
            }
            
            if ($adminFunctions->updateShippingFeeStatus($id, $isActive)) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Shipping fee status updated successfully!'
                ]);
            } else {
                throw new Exception('Failed to update shipping fee status');
            }
            break;
            
        case 'reorder':
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                throw new Exception('Invalid request method');
            }
            
            $orderData = $_POST['order'] ?? [];
            
            if (empty($orderData)) {
                throw new Exception('No order data provided');
            }
            
            if ($adminFunctions->updateShippingFeeOrder($orderData)) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Shipping fee order updated successfully!'
                ]);
            } else {
                throw new Exception('Failed to update shipping fee order');
            }
            break;
            
        default:
            throw new Exception('Invalid action');
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>