<?php
require_once '../includes/auth.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['product_id']) || !isset($input['duration_hours'])) {
        throw new Exception('Missing required parameters');
    }
    
    $productId = (int)$input['product_id'];
    $durationHours = (int)$input['duration_hours'];
    
    if ($durationHours < 1 || $durationHours > 168) {
        throw new Exception('Duration must be between 1 and 168 hours');
    }
    
    $adminFunctions = new AdminFunctions();
    
    // Start flash sale
    $startTime = date('Y-m-d H:i:s');
    $endTime = date('Y-m-d H:i:s', strtotime("+{$durationHours} hours"));
    
    $query = "UPDATE products SET 
                is_flash_sale = 1, 
                flash_sale_duration_hours = :duration,
                flash_sale_started_at = :start_time,
                updated_at = NOW()
              WHERE id = :product_id";
    
    $stmt = $adminFunctions->conn->prepare($query);
    $stmt->bindValue(':duration', $durationHours, PDO::PARAM_INT);
    $stmt->bindValue(':start_time', $startTime);
    $stmt->bindValue(':product_id', $productId, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        echo json_encode([
            'success' => true, 
            'message' => 'Flash sale started successfully',
            'end_time' => $endTime
        ]);
    } else {
        throw new Exception('Failed to start flash sale');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>