<?php
session_start();
require_once __DIR__ . '/../../config/database.php';

class AdminAuth {
    private $conn;
    
    public function __construct() {
        $this->conn = getDB();
    }
    
    public function login($email, $password) {
        try {
            // Query the database for admin user
            $query = "SELECT id, username, email, password_hash, full_name, role, is_active 
                      FROM admin_users 
                      WHERE (email = :email OR username = :email) AND is_active = 1";
            
            $stmt = $this->conn->prepare($query);
            $stmt->bindValue(':email', $email);
            $stmt->execute();
            
            $admin = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // Debug logging
            error_log("Login attempt for: " . $email);
            error_log("Admin found: " . ($admin ? 'Yes' : 'No'));
            if ($admin) {
                error_log("Admin active: " . ($admin['is_active'] ? 'Yes' : 'No'));
                error_log("Password hash exists: " . (!empty($admin['password_hash']) ? 'Yes' : 'No'));
            }
            
            if ($admin && $admin['password_hash'] === $password) {
                // Login successful
                $_SESSION['admin_logged_in'] = true;
                $_SESSION['admin_id'] = $admin['id'];
                $_SESSION['admin_email'] = $admin['email'];
                $_SESSION['admin_username'] = $admin['username'];
                $_SESSION['admin_name'] = $admin['full_name'];
                $_SESSION['admin_role'] = $admin['role'];
                
                error_log("Login successful for: " . $email);
                return true;
            } else {
                error_log("Login failed for: " . $email . " - Password verification failed");
            }
            
            return false;
        } catch (Exception $e) {
            error_log("Admin login error: " . $e->getMessage());
            return false;
        }
    }
    
    public function logout() {
        session_destroy();
        return true;
    }
    
    public function isLoggedIn() {
        return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
    }
    
    public function requireLogin() {
        if (!$this->isLoggedIn()) {
            // Use absolute path from document root to avoid path issues
            $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'];
            $adminPath = dirname($_SERVER['PHP_SELF']);
            
            // Remove any trailing slashes and ensure we're in the admin directory
            $adminPath = rtrim($adminPath, '/');
            if (strpos($adminPath, '/admin/pages') !== false) {
                $adminPath = str_replace('/admin/pages', '/admin', $adminPath);
            }
            
            header('Location: ' . $baseUrl . $adminPath . '/login.php');
            exit();
        }
    }
    
    public function getAdminName() {
        return $_SESSION['admin_name'] ?? 'Admin';
    }
    
    public function getAdminEmail() {
        return $_SESSION['admin_email'] ?? '';
    }
    
    public function getAdminId() {
        return $_SESSION['admin_id'] ?? null;
    }
    
    public function getAdminRole() {
        return $_SESSION['admin_role'] ?? 'admin';
    }
    
    public function getAdminUsername() {
        return $_SESSION['admin_username'] ?? '';
    }
    
    public function hasRole($role) {
        return $this->getAdminRole() === $role;
    }
    
    public function isOwner() {
        return $this->hasRole('owner');
    }
    
    public function isManager() {
        return $this->hasRole('manager');
    }
}

$adminAuth = new AdminAuth();
?>