<?php
// AJAX endpoint to fetch product data for editing
header('Content-Type: application/json');

require_once '../includes/auth.php';
require_once '../includes/functions.php';

$adminAuth->requireLogin();

if (!isset($_GET['id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Product ID is required']);
    exit;
}

$productId = intval($_GET['id']);
$product = $adminFunctions->getProductWithVariations($productId);

if (!$product) {
    http_response_code(404);
    echo json_encode(['error' => 'Product not found']);
    exit;
}

echo json_encode($product);

