<?php
session_start();
require_once '../models/User.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] === 'guest') {
    echo json_encode(['success' => false, 'message' => 'User not authenticated']);
    exit();
}

// Check if request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

// Get user ID
$user_id = $_SESSION['user_id'];

try {
    $user = new User();
    
    // Verify user exists
    $user_data = $user->getById($user_id);
    if (!$user_data) {
        echo json_encode(['success' => false, 'message' => 'User not found']);
        exit();
    }
    
    // Check if user is a guest (prevent deletion of guest accounts)
    if (isset($user_data['is_guest']) && $user_data['is_guest']) {
        echo json_encode(['success' => false, 'message' => 'Cannot delete guest account']);
        exit();
    }
    
    // Delete the account
    $result = $user->deleteAccount($user_id);
    
    if ($result) {
        // Clear session
        session_destroy();
        
        echo json_encode([
            'success' => true, 
            'message' => 'Account deleted successfully',
            'redirect' => 'index.php'
        ]);
    } else {
        // Get more detailed error information
        $error_details = error_get_last();
        $error_message = 'Failed to delete account';
        
        if ($error_details) {
            $error_message .= ' - ' . $error_details['message'];
        }
        
        echo json_encode(['success' => false, 'message' => $error_message]);
    }
    
} catch (Exception $e) {
    error_log("Delete account error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'An error occurred while deleting account']);
}
?>