<?php
header('Content-Type: application/json');
require_once '../models/Product.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $product = new Product();
    
    // Build filters array
    $filters = [];
    
    if (!empty($input['scent'])) {
        $filters['scent'] = $input['scent'];
    }
    
    if (!empty($input['notes'])) {
        $filters['notes'] = $input['notes'];
    }
    
    if (!empty($input['season'])) {
        $filters['season'] = $input['season'];
    }
    
    if (!empty($input['recommendation'])) {
        $filters['recommendation'] = $input['recommendation'];
    }
    
    // Get filtered products
    $products = $product->filterProducts($filters);
    
    // Generate HTML for products
    $html = '';
    if (empty($products)) {
        $html = '<div class="no-products-found" style="text-align: center;">
            <i class="fas fa-search"></i>
            <h3>No perfumes found</h3>
            <p>Try adjusting your filters to find the perfect scent for you.</p>
        </div>';
    } else {
        foreach ($products as $prod) {
            $html .= '<div class="new-arrival-card ' . ($prod['is_out_of_stock'] ? 'out-of-stock' : '') . '" onclick="viewProduct(' . $prod['id'] . ')">'
                     . '<div class="new-arrival-image-container">'
                     . '<img src="' . htmlspecialchars($prod['image']) . '" alt="' . htmlspecialchars($prod['name']) . '" class="new-arrival-image" onerror="this.src=\'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTAwIiBoZWlnaHQ9IjEwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cmVjdCB3aWR0aD0iMTAwIiBoZWlnaHQ9IjEwMCIgZmlsbD0iI2Y0ZjRmNCIvPjx0ZXh0IHg9IjUwIiB5PSI1MCIgZm9udC1mYW1pbHk9IkFyaWFsIiBmb250LXNpemU9IjE0IiBmaWxsPSIjOTk5IiB0ZXh0LWFuY2hvcj0ibWlkZGxlIj5JbWFnZTwvdGV4dD48L3N2Zz4=\'" />';

            if ($prod['is_out_of_stock']) {
                $html .= '<div class="out-of-stock-overlay">
                            <span>Out of Stock</span>
                          </div>';
            }
            
            $html .= '</div>
                      <div class="new-arrival-info">
                        <div class="new-arrival-price">';
            
            $html .= '<span class="current-price">' . htmlspecialchars($prod['price_range']) . '</span>';
            
            $html .= '</div>
                      <h3 class="new-arrival-name">' . htmlspecialchars($prod['name']) . '</h3>
                      <p class="new-arrival-volume">';
            
            if (!empty($prod['variations_detail'])) {
                $html .= htmlspecialchars($prod['variations_detail'][0]['version_type'] . ' - ' . $prod['variations_detail'][0]['size']);
                if (count($prod['variations_detail']) > 1) {
                    $html .= '<span class="more-variations">+' . (count($prod['variations_detail']) - 1) . ' more</span>';
                }
            } else {
                $html .= 'No variations';
            }
            
            $html .= '</p>
                      <div class="product-filter-tags">
                        <span class="filter-tag scent-tag">' . htmlspecialchars($prod['scent']) . '</span>
                        <span class="filter-tag season-tag">' . htmlspecialchars($prod['season']) . '</span>
                        <span class="filter-tag recommendation-tag">' . htmlspecialchars($prod['recommendation']) . '</span>
                      </div>
                    </div>
                  </div>';
        }
    }
    
    echo json_encode([
        'success' => true,
        'html' => $html,
        'count' => count($products)
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Server error: ' . $e->getMessage()]);
}
?>