<?php
session_start();
require_once '../includes/auth-check.php';
require_once '../admin/includes/Voucher.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'User not logged in']);
    exit;
}

try {
    $userId = getUserId();
    $voucherModel = new Voucher();
    
    // Get user's redeemed vouchers (active ones only)
    $claimedVouchers = $voucherModel->getUserRedeemedVouchers($userId, 'active');
    
    // Filter out vouchers that are already used
    $availableVouchers = [];
    foreach ($claimedVouchers as $voucher) {
        // Check if voucher is not used (not in orders)
        if (!$voucherModel->isVoucherUsed($userId, $voucher['voucher_id'])) {
            $availableVouchers[] = $voucher;
        }
    }
    
    echo json_encode([
        'success' => true,
        'vouchers' => $availableVouchers,
        'count' => count($availableVouchers)
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error fetching vouchers: ' . $e->getMessage()]);
}
?>
