<?php
// Suppress all output except JSON
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

session_start();
require_once '../includes/auth-check.php';
require_once '../admin/includes/Voucher.php';
require_once '../models/Loyalty.php';

// Clear any output buffer
ob_clean();

header('Content-Type: application/json');

// Check if user is logged in
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Please log in to redeem vouchers']);
    exit;
}

$userId = getUserId();
$input = json_decode(file_get_contents('php://input'), true);
$voucherId = $input['voucher_id'] ?? null;

if (!$voucherId) {
    echo json_encode(['success' => false, 'message' => 'Invalid voucher ID']);
    exit;
}

try {
    $voucherModel = new Voucher();
    $loyaltyModel = new Loyalty();
    
    // Get user's current points
    $loyaltyData = $loyaltyModel->getUserLoyaltyData($userId);
    if (!$loyaltyData) {
        echo json_encode(['success' => false, 'message' => 'Loyalty account not found']);
        exit;
    }
    
    // Get voucher details
    $voucher = $voucherModel->getVoucherById($voucherId);
    if (!$voucher || !$voucher['is_active']) {
        echo json_encode(['success' => false, 'message' => 'Voucher not available']);
        exit;
    }
    
    // Check if user has enough points
    if ($loyaltyData['points'] < $voucher['points_required']) {
        echo json_encode(['success' => false, 'message' => 'Insufficient points. You need ' . number_format($voucher['points_required']) . ' points to redeem this voucher.']);
        exit;
    }
    
    // Check if voucher is still valid
    $today = date('Y-m-d');
    if ($voucher['valid_from'] > $today || $voucher['valid_until'] < $today) {
        echo json_encode(['success' => false, 'message' => 'Voucher has expired or is not yet valid']);
        exit;
    }
    
    // Check if voucher has remaining redemptions
    if ($voucher['max_redemptions'] && $voucher['current_redemptions'] >= $voucher['max_redemptions']) {
        echo json_encode(['success' => false, 'message' => 'Voucher has reached maximum redemptions']);
        exit;
    }
    
    // Check if user has already redeemed this voucher (one voucher only per user)
    $existingRedemption = $voucherModel->checkUserVoucherRedemption($userId, $voucherId);
    if ($existingRedemption) {
        echo json_encode(['success' => false, 'message' => 'You have already redeemed this voucher. Each user can only redeem a voucher once.']);
        exit;
    }
    
    // Redeem the voucher
    $voucherModel->redeemVoucher($userId, $voucherId);
    
    // Deduct points from user's account
    $loyaltyModel->deductPoints($userId, $voucher['points_required'], 'Voucher redemption: ' . $voucher['voucher_name']);
    
    echo json_encode([
        'success' => true, 
        'message' => 'Voucher redeemed successfully!',
        'voucher_name' => $voucher['voucher_name'],
        'points_used' => $voucher['points_required']
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} catch (Error $e) {
    echo json_encode(['success' => false, 'message' => 'Server error occurred']);
}
?>