<?php
session_start();
require_once '../models/Cart.php';

header('Content-Type: application/json');

$cart = new Cart();
$user_id = $_SESSION['user_id'] ?? null;
$session_id = session_id();

$input = json_decode(file_get_contents('php://input'), true);
$action = $input['action'] ?? '';

try {
    switch ($action) {
        case 'update_quantity':
            $cart_item_id = (int)($input['cart_item_id'] ?? 0);
            $quantity = (int)($input['quantity'] ?? 0);
            
            if (!$cart_item_id) {
                throw new Exception('Invalid cart item ID');
            }
            
            if ($cart->updateQuantity($cart_item_id, $quantity)) {
                $cart_total = $cart->getCartTotal($user_id, $session_id);
                echo json_encode([
                    'success' => true,
                    'message' => 'Cart updated successfully',
                    'cart_total' => $cart_total
                ]);
            } else {
                throw new Exception('Failed to update cart');
            }
            break;
            
        case 'remove':
            $cart_item_id = (int)($input['cart_item_id'] ?? 0);
            
            if (!$cart_item_id) {
                throw new Exception('Invalid cart item ID');
            }
            
            if ($cart->removeItem($cart_item_id)) {
                $cart_total = $cart->getCartTotal($user_id, $session_id);
                echo json_encode([
                    'success' => true,
                    'message' => 'Item removed from cart',
                    'cart_total' => $cart_total
                ]);
            } else {
                throw new Exception('Failed to remove item from cart');
            }
            break;
            
        case 'get_total':
            $cart_total = $cart->getCartTotal($user_id, $session_id);
            $shipping_info = null;
            
            if ($cart_total['subtotal'] > 0) {
                $shipping_info = $cart->getShippingInfo($cart_total['subtotal'], $cart_total['total_quantity'] * 0.1);
            }
            
            echo json_encode([
                'success' => true,
                'cart_total' => $cart_total,
                'shipping_info' => $shipping_info
            ]);
            break;
            
        default:
            throw new Exception('Invalid action');
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>