<?php
session_start();
require_once 'config/database.php';
require_once 'models/Cart.php';

echo "<h1>Cart Debug Test</h1>";

try {
    $pdo = getDB();
    echo "<p>✅ Database connection successful</p>";
    
    // Check cart table structure
    $stmt = $pdo->query("DESCRIBE cart");
    $columns = $stmt->fetchAll();
    echo "<h2>Cart Table Structure:</h2>";
    echo "<ul>";
    foreach ($columns as $column) {
        echo "<li>{$column['Field']} - {$column['Type']}</li>";
    }
    echo "</ul>";
    
    // Check if version column exists
    $hasVersion = false;
    foreach ($columns as $column) {
        if ($column['Field'] === 'version') {
            $hasVersion = true;
            break;
        }
    }
    
    if (!$hasVersion) {
        echo "<p>❌ Version column missing. Adding it...</p>";
        $pdo->exec("ALTER TABLE cart ADD COLUMN version VARCHAR(50) DEFAULT NULL AFTER size");
        echo "<p>✅ Version column added</p>";
    } else {
        echo "<p>✅ Version column exists</p>";
    }
    
    // Test cart functionality
    echo "<h2>Testing Cart Functionality:</h2>";
    
    // Set a test user session
    $_SESSION['user_id'] = 1; // Assuming user ID 1 exists
    
    $cart = new Cart();
    echo "<p>✅ Cart object created</p>";
    
    // Test adding an item
    $result = $cart->addItem(1, session_id(), 1, 1, 25.00, '50ml', 'EDP / LIGHT');
    if ($result) {
        echo "<p>✅ Successfully added item to cart. Cart item ID: $result</p>";
    } else {
        echo "<p>❌ Failed to add item to cart</p>";
    }
    
    // Get cart count
    $count = $cart->getCartCount(1, session_id());
    echo "<p>Cart count: $count</p>";
    
} catch (Exception $e) {
    echo "<p>❌ Error: " . $e->getMessage() . "</p>";
}
?>