<?php
// Google OAuth Configuration
define('GOOGLE_CLIENT_ID', '535785324291-m1viscd8r46hhusu6peqcb5ovpeb6do6.apps.googleusercontent.com');
define('GOOGLE_CLIENT_SECRET', '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');
define('GOOGLE_PROJECT_ID', 'days-parfum');
define('GOOGLE_AUTH_URI', 'https://accounts.google.com/o/oauth2/auth');
define('GOOGLE_TOKEN_URI', 'https://oauth2.googleapis.com/token');
define('GOOGLE_CERT_URL', 'https://www.googleapis.com/oauth2/v1/certs');

// OAuth scopes
define('GOOGLE_SCOPES', 'email profile openid');

// Redirect URI Configuration
// IMPORTANT: Update PRODUCTION_DOMAIN with your actual domain
define('PRODUCTION_DOMAIN', '2dayparfum.com'); // Your actual domain
define('PRODUCTION_PATH', '/apps'); // Your app path

function getRedirectURI() {
    // Check if we're in production (not localhost)
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    
    if ($host === 'localhost' || strpos($host, '127.0.0.1') !== false || strpos($host, 'localhost') !== false) {
        // Development environment
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
        $script_dir = dirname($_SERVER['SCRIPT_NAME']);
        $base_path = ($script_dir === '/') ? '' : $script_dir;
        return $protocol . '://' . $host . $base_path . '/google-callback.php';
    } else {
        // Production environment - use fixed URL
        return 'https://' . PRODUCTION_DOMAIN . PRODUCTION_PATH . '/google-callback.php';
    }
}

define('GOOGLE_REDIRECT_URI', getRedirectURI());

// Generate OAuth URL
function getGoogleOAuthURL() {
    $params = [
        'client_id' => GOOGLE_CLIENT_ID,
        'redirect_uri' => GOOGLE_REDIRECT_URI,
        'scope' => GOOGLE_SCOPES,
        'response_type' => 'code',
        'access_type' => 'offline',
        'prompt' => 'select_account', // Force account selection
        'include_granted_scopes' => 'true' // Better mobile compatibility
    ];
    
    return GOOGLE_AUTH_URI . '?' . http_build_query($params);
}

// Exchange authorization code for access token
function getGoogleAccessToken($code) {
    $data = [
        'client_id' => GOOGLE_CLIENT_ID,
        'client_secret' => GOOGLE_CLIENT_SECRET,
        'redirect_uri' => GOOGLE_REDIRECT_URI,
        'grant_type' => 'authorization_code',
        'code' => $code
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, GOOGLE_TOKEN_URI);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded'
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        return json_decode($response, true);
    }
    
    return false;
}

// Get user info from Google
function getGoogleUserInfo($accessToken) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://www.googleapis.com/oauth2/v2/userinfo');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $accessToken
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        return json_decode($response, true);
    }
    
    return false;
}
?>